/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.beans;

import com.gemstone.gemfire.cache.wan.GatewayEventFilter;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.cache.wan.GatewayTransportFilter;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventDispatcher;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderStats;
import com.gemstone.gemfire.management.internal.ManagementStrings;
import com.gemstone.gemfire.management.internal.beans.stats.MBeanStatsMonitor;
import com.gemstone.gemfire.management.internal.beans.stats.StatType;
import com.gemstone.gemfire.management.internal.beans.stats.StatsAverageLatency;
import com.gemstone.gemfire.management.internal.beans.stats.StatsRate;
import java.util.List;

public class GatewaySenderMBeanBridge {
    private GatewaySender sender;
    private MBeanStatsMonitor monitor;
    private StatsRate eventsQueuedRate;
    private StatsRate eventsReceivedRate;
    private StatsRate batchesDispatchedRate;
    private StatsAverageLatency batchDistributionAvgLatency;
    private GatewaySenderEventDispatcher dispatcher;
    private AbstractGatewaySender abstractSender;

    public GatewaySenderMBeanBridge(GatewaySender sender) {
        this.sender = sender;
        this.monitor = new MBeanStatsMonitor(ManagementStrings.GATEWAY_SENDER_MONITOR.toLocalizedString());
        this.abstractSender = (AbstractGatewaySender)this.sender;
        GatewaySenderStats stats = this.abstractSender.getStatistics();
        this.addGatewaySenderStats(stats);
        this.initializeStats();
    }

    public void setDispatcher() {
        AbstractGatewaySenderEventProcessor eventProcessor = this.abstractSender.getEventProcessor();
        if (eventProcessor != null) {
            this.dispatcher = this.abstractSender.getEventProcessor().getDispatcher();
        }
    }

    public void addGatewaySenderStats(GatewaySenderStats gatewaySenderStats) {
        this.monitor.addStatisticsToMonitor(gatewaySenderStats.getStats());
    }

    public void stopMonitor() {
        this.monitor.stopListener();
    }

    private void initializeStats() {
        this.eventsQueuedRate = new StatsRate("eventsQueued", StatType.INT_TYPE, this.monitor);
        this.eventsReceivedRate = new StatsRate("eventsReceived", StatType.INT_TYPE, this.monitor);
        this.batchesDispatchedRate = new StatsRate("batchesDistributed", StatType.INT_TYPE, this.monitor);
        this.batchDistributionAvgLatency = new StatsAverageLatency("batchesDistributed", StatType.INT_TYPE, "batchDistributionTime", this.monitor);
    }

    public int getAlertThreshold() {
        return this.sender.getAlertThreshold();
    }

    public int getBatchSize() {
        return this.sender.getBatchSize();
    }

    public long getBatchTimeInterval() {
        return this.sender.getBatchTimeInterval();
    }

    public String getOverflowDiskStoreName() {
        return this.sender.getDiskStoreName();
    }

    public String[] getGatewayEventFilters() {
        List<GatewayEventFilter> filters = this.sender.getGatewayEventFilters();
        String[] filtersStr = null;
        if (filters == null || filters.size() <= 0) {
            return filtersStr;
        }
        filtersStr = new String[filters.size()];
        int j = 0;
        for (GatewayEventFilter filter : filters) {
            filtersStr[j] = filter.toString();
            ++j;
        }
        return filtersStr;
    }

    public String[] getGatewayTransportFilters() {
        List<GatewayTransportFilter> transportFilters = this.sender.getGatewayTransportFilters();
        String[] transportFiltersStr = null;
        if (transportFilters == null || transportFilters.size() <= 0) {
            return transportFiltersStr;
        }
        transportFiltersStr = new String[transportFilters.size()];
        int j = 0;
        for (GatewayTransportFilter listener : transportFilters) {
            transportFiltersStr[j] = listener.getClass().getCanonicalName();
            ++j;
        }
        return transportFiltersStr;
    }

    public int getMaximumQueueMemory() {
        return this.sender.getMaximumQueueMemory();
    }

    public int getRemoteDSId() {
        return this.sender.getRemoteDSId();
    }

    public String getSenderId() {
        return this.sender.getId();
    }

    public int getSocketBufferSize() {
        return this.sender.getSocketBufferSize();
    }

    public long getSocketReadTimeout() {
        return this.sender.getSocketReadTimeout();
    }

    public boolean isBatchConflationEnabled() {
        return this.sender.isBatchConflationEnabled();
    }

    public boolean isManualStart() {
        return this.sender.isManualStart();
    }

    public boolean isPaused() {
        return this.sender.isPaused();
    }

    public boolean isPersistenceEnabled() {
        return this.sender.isPersistenceEnabled();
    }

    public boolean isRunning() {
        return this.sender.isRunning();
    }

    public void pause() {
        this.sender.pause();
    }

    public void resume() {
        this.sender.resume();
    }

    public void start() {
        this.sender.start();
    }

    public void stop() {
        this.sender.stop();
    }

    public void rebalance() {
        this.sender.rebalance();
    }

    public boolean isPrimary() {
        return ((AbstractGatewaySender)this.sender).isPrimary();
    }

    public int getDispatcherThreads() {
        return this.sender.getDispatcherThreads();
    }

    public String getOrderPolicy() {
        return this.sender.getOrderPolicy() != null ? this.sender.getOrderPolicy().name() : null;
    }

    public boolean isDiskSynchronous() {
        return this.sender.isDiskSynchronous();
    }

    public boolean isParallel() {
        return this.sender.isParallel();
    }

    public int getTotalBatchesRedistributed() {
        return this.getStatistic("batchesRedistributed").intValue();
    }

    public int getTotalEventsConflated() {
        return this.getStatistic("eventsNotQueuedConflated").intValue();
    }

    public int getEventQueueSize() {
        return this.abstractSender.getEventQueueSize();
    }

    public float getEventsQueuedRate() {
        return this.eventsQueuedRate.getRate();
    }

    public float getEventsReceivedRate() {
        return this.eventsReceivedRate.getRate();
    }

    public float getBatchesDispatchedRate() {
        return this.batchesDispatchedRate.getRate();
    }

    public long getAverageDistributionTimePerBatch() {
        return this.batchDistributionAvgLatency.getAverageLatency();
    }

    private Number getStatistic(String statName) {
        if (this.monitor != null) {
            return this.monitor.getStatistic(statName);
        }
        return 0;
    }

    public String getGatewayReceiver() {
        return ((AbstractGatewaySender)this.sender).getServerLocation().toString();
    }

    public boolean isConnected() {
        return this.dispatcher != null && this.dispatcher.isConnectedToRemote();
    }

    public int getEventsExceedingAlertThreshold() {
        return this.getStatistic("eventsExceedingAlertThreshold").intValue();
    }
}

