/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ResourceEvent;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.management.AlreadyRunningException;
import com.gemstone.gemfire.management.AsyncEventQueueMXBean;
import com.gemstone.gemfire.management.CacheServerMXBean;
import com.gemstone.gemfire.management.DiskStoreMXBean;
import com.gemstone.gemfire.management.DistributedLockServiceMXBean;
import com.gemstone.gemfire.management.DistributedRegionMXBean;
import com.gemstone.gemfire.management.DistributedSystemMXBean;
import com.gemstone.gemfire.management.GatewayReceiverMXBean;
import com.gemstone.gemfire.management.GatewaySenderMXBean;
import com.gemstone.gemfire.management.LocatorMXBean;
import com.gemstone.gemfire.management.LockServiceMXBean;
import com.gemstone.gemfire.management.ManagementException;
import com.gemstone.gemfire.management.ManagerMXBean;
import com.gemstone.gemfire.management.MemberMXBean;
import com.gemstone.gemfire.management.RegionMXBean;
import com.gemstone.gemfire.management.internal.BaseManagementService;
import com.gemstone.gemfire.management.internal.FederatingManager;
import com.gemstone.gemfire.management.internal.FederationComponent;
import com.gemstone.gemfire.management.internal.LocalFilterChain;
import com.gemstone.gemfire.management.internal.LocalManager;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.gemstone.gemfire.management.internal.ManagementAgent;
import com.gemstone.gemfire.management.internal.ManagementFunction;
import com.gemstone.gemfire.management.internal.ManagementMembershipListener;
import com.gemstone.gemfire.management.internal.ManagementResourceRepo;
import com.gemstone.gemfire.management.internal.ManagementStrings;
import com.gemstone.gemfire.management.internal.NotificationHub;
import com.gemstone.gemfire.management.internal.ProxyListener;
import com.gemstone.gemfire.management.internal.beans.ManagementAdapter;
import com.gemstone.gemfire.management.membership.MembershipEvent;
import com.gemstone.gemfire.management.membership.MembershipListener;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.Notification;
import javax.management.ObjectName;
import org.apache.logging.log4j.Logger;

public final class SystemManagementService
extends BaseManagementService {
    private static final Logger logger = LogService.getLogger();
    private InternalDistributedSystem system;
    private LocalManager localManager;
    private NotificationHub notificationHub;
    private LocalFilterChain localFilterChain;
    private volatile boolean closed = false;
    private volatile boolean isStarted = false;
    private MBeanJMXAdapter jmxAdapter;
    private Cache cache;
    private FederatingManager federatingManager;
    private final ManagementAgent agent;
    private ManagementResourceRepo repo;
    private ManagementMembershipListener listener;
    private List<ProxyListener> proxyListeners;
    private UniversalListenerContainer universalListenerContainer = new UniversalListenerContainer();

    public static BaseManagementService newSystemManagementService(Cache cache) {
        return new SystemManagementService(cache).init();
    }

    protected SystemManagementService(Cache cache) {
        this.cache = cache;
        this.system = (InternalDistributedSystem)cache.getDistributedSystem();
        if (!this.system.isConnected()) {
            throw new DistributedSystemDisconnectedException(LocalizedStrings.InternalDistributedSystem_THIS_CONNECTION_TO_A_DISTRIBUTED_SYSTEM_HAS_BEEN_DISCONNECTED.toLocalizedString());
        }
        this.localFilterChain = new LocalFilterChain();
        this.jmxAdapter = new MBeanJMXAdapter();
        this.repo = new ManagementResourceRepo();
        this.notificationHub = new NotificationHub(this.repo);
        this.agent = this.system.getConfig().getJmxManager() ? new ManagementAgent(this.system.getConfig()) : null;
        ManagementFunction function = new ManagementFunction(this.notificationHub);
        FunctionService.registerFunction(function);
        this.proxyListeners = new CopyOnWriteArrayList<ProxyListener>();
    }

    private SystemManagementService init() {
        try {
            this.localManager = new LocalManager(this.repo, this.system, this, this.cache);
            this.localManager.startManager();
            this.listener = new ManagementMembershipListener(this);
            this.system.getDistributionManager().addMembershipListener(this.listener);
            this.isStarted = true;
            return this;
        }
        catch (CancelException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ManagementException(e);
        }
    }

    public LocalManager getLocalManager() {
        return this.localManager;
    }

    public NotificationHub getNotificationHub() {
        return this.notificationHub;
    }

    public FederatingManager getFederatingManager() {
        return this.federatingManager;
    }

    public MBeanJMXAdapter getJMXAdapter() {
        return this.jmxAdapter;
    }

    public ManagementAgent getManagementAgent() {
        return this.agent;
    }

    public boolean isStartedAndOpen() {
        if (!this.isStarted) {
            return false;
        }
        if (this.closed) {
            return false;
        }
        return this.system.isConnected();
    }

    private void verifyManagementService() {
        if (!this.isStarted) {
            throw new ManagementException(ManagementStrings.Management_Service_MANAGEMENT_SERVICE_NOT_STARTED_YET.toLocalizedString());
        }
        if (!this.system.isConnected()) {
            throw new ManagementException(ManagementStrings.Management_Service_NOT_CONNECTED_TO_DISTRIBUTED_SYSTEM.toLocalizedString());
        }
        if (this.closed) {
            throw new ManagementException(ManagementStrings.Management_Service_MANAGEMENT_SERVICE_IS_CLOSED.toLocalizedString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Map map = instances;
        synchronized (map) {
            if (this.closed) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Closing Management Service");
            }
            if (this.listener != null && this.system.isConnected()) {
                this.system.getDistributionManager().removeMembershipListener(this.listener);
            }
            if (this.federatingManager != null && this.federatingManager.isRunning()) {
                this.federatingManager.stopManager();
            }
            this.notificationHub.cleanUpListeners();
            this.jmxAdapter.cleanJMXResource();
            if (this.localManager.isRunning()) {
                this.localManager.stopManager();
            }
            if (this.agent != null && this.agent.isRunning()) {
                this.agent.stopAgent();
            }
            this.getGemFireCacheImpl().getJmxManagerAdvisor().broadcastChange();
            instances.remove(this.cache);
            this.localManager = null;
            this.closed = true;
        }
    }

    @Override
    public <T> void federate(ObjectName objectName, Class<T> interfaceClass, boolean notificationEmitter) {
        this.verifyManagementService();
        if (!objectName.getDomain().equalsIgnoreCase("GemFire")) {
            throw new ManagementException(ManagementStrings.Management_Service_NOT_A_GEMFIRE_DOMAIN_MBEAN.toLocalizedString());
        }
        if (!this.jmxAdapter.isRegistered(objectName)) {
            throw new ManagementException(ManagementStrings.Management_Service_MBEAN_NOT_REGISTERED_IN_GEMFIRE_DOMAIN.toLocalizedString());
        }
        if (notificationEmitter && !this.jmxAdapter.hasNotificationSupport(objectName)) {
            throw new ManagementException(ManagementStrings.Management_Service_MBEAN_DOES_NOT_HAVE_NOTIFICATION_SUPPORT.toLocalizedString());
        }
        Object object = this.jmxAdapter.getMBeanObject(objectName);
        FederationComponent fedComp = new FederationComponent(object, objectName, interfaceClass, notificationEmitter);
        if (ManagementAdapter.refreshOnInit.contains(interfaceClass)) {
            fedComp.refreshObjectState(true);
        }
        this.localManager.markForFederation(objectName, fedComp);
        if (this.isManager()) {
            this.afterCreateProxy(objectName, interfaceClass, object, fedComp);
        }
    }

    @Override
    public CacheServerMXBean getLocalCacheServerMXBean(int serverPort) {
        CacheServerMXBean bean = this.jmxAdapter.getClientServiceMXBean(serverPort);
        return bean;
    }

    @Override
    public long getLastUpdateTime(ObjectName objectName) {
        if (!this.isStartedAndOpen()) {
            return 0L;
        }
        if (this.federatingManager == null) {
            return 0L;
        }
        if (!this.federatingManager.isRunning()) {
            return 0L;
        }
        if (this.jmxAdapter.isLocalMBean(objectName)) {
            return 0L;
        }
        return this.federatingManager.getLastUpdateTime(objectName);
    }

    @Override
    public DiskStoreMXBean getLocalDiskStoreMBean(String diskStoreName) {
        DiskStoreMXBean bean = this.jmxAdapter.getLocalDiskStoreMXBean(diskStoreName);
        return bean;
    }

    @Override
    public LockServiceMXBean getLocalLockServiceMBean(String lockSreviceName) {
        LockServiceMXBean bean = this.jmxAdapter.getLocalLockServiceMXBean(lockSreviceName);
        return bean;
    }

    @Override
    public RegionMXBean getLocalRegionMBean(String regionPath) {
        RegionMXBean bean = this.jmxAdapter.getLocalRegionMXBean(regionPath);
        return bean;
    }

    public <T> T getMBeanProxy(ObjectName objectName, Class<T> interfaceClass) {
        if (!this.isStartedAndOpen()) {
            return null;
        }
        if (this.federatingManager == null) {
            return null;
        }
        if (!this.federatingManager.isRunning()) {
            return null;
        }
        return this.federatingManager.findProxy(objectName, interfaceClass);
    }

    @Override
    public MemberMXBean getMemberMXBean() {
        return this.jmxAdapter.getMemberMXBean();
    }

    @Override
    public Set<ObjectName> queryMBeanNames(DistributedMember member) {
        if (!this.isStartedAndOpen()) {
            return Collections.emptySet();
        }
        if (this.cache.getDistributedSystem().getDistributedMember().equals(member)) {
            return this.jmxAdapter.getLocalGemFireMBean().keySet();
        }
        if (this.federatingManager == null) {
            return Collections.emptySet();
        }
        if (!this.federatingManager.isRunning()) {
            return Collections.emptySet();
        }
        return this.federatingManager.findAllProxies(member);
    }

    @Override
    public ObjectName registerMBean(Object object, ObjectName objectName) {
        this.verifyManagementService();
        if (this.localFilterChain.isFiltered(objectName)) {
            return null;
        }
        return this.jmxAdapter.registerMBean(object, objectName, false);
    }

    public ObjectName registerInternalMBean(Object object, ObjectName objectName) {
        this.verifyManagementService();
        if (this.localFilterChain.isFiltered(objectName)) {
            return null;
        }
        return this.jmxAdapter.registerMBean(object, objectName, true);
    }

    @Override
    public void unregisterMBean(ObjectName objectName) {
        FederationComponent removedObj;
        if (!this.isStartedAndOpen()) {
            return;
        }
        this.verifyManagementService();
        if (this.isManager() && (removedObj = this.localManager.getFedComponents().get(objectName)) != null) {
            this.afterRemoveProxy(objectName, removedObj.getInterfaceClass(), removedObj.getMBeanObject(), removedObj);
        }
        this.jmxAdapter.unregisterMBean(objectName);
        this.localManager.unMarkForFederation(objectName);
    }

    @Override
    public boolean isManager() {
        return this.isManagerCreated() && this.federatingManager.isRunning();
    }

    public boolean isManagerCreated() {
        if (!this.isStartedAndOpen()) {
            return false;
        }
        return this.federatingManager != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startManager() {
        if (!this.getGemFireCacheImpl().getSystem().getConfig().getJmxManager()) {
            throw new ManagementException("Could not start the manager because the gemfire property \"jmx-manager\" is false.");
        }
        Map map = instances;
        synchronized (map) {
            this.verifyManagementService();
            if (this.federatingManager != null && this.federatingManager.isRunning()) {
                throw new AlreadyRunningException(ManagementStrings.Management_Service_MANAGER_ALREADY_RUNNING.toLocalizedString());
            }
            boolean needsToBeStarted = false;
            if (!this.isManagerCreated()) {
                this.createManager();
                needsToBeStarted = true;
            } else if (!this.federatingManager.isRunning()) {
                needsToBeStarted = true;
            }
            if (needsToBeStarted) {
                boolean started = false;
                try {
                    this.system.handleResourceEvent(ResourceEvent.MANAGER_START, null);
                    this.federatingManager.startManager();
                    if (this.agent != null) {
                        this.agent.startAgent(this.getGemFireCacheImpl());
                    }
                    this.getGemFireCacheImpl().getJmxManagerAdvisor().broadcastChange();
                    started = true;
                }
                catch (RuntimeException e) {
                    logger.error("Jmx manager could not be started because {}", new Object[]{e.getMessage(), e});
                    throw e;
                }
                catch (Error e) {
                    logger.error("Jmx manager could not be started because {}", new Object[]{e.getMessage(), e});
                    throw e;
                }
                finally {
                    if (!started) {
                        if (this.federatingManager != null) {
                            this.federatingManager.stopManager();
                        }
                        this.system.handleResourceEvent(ResourceEvent.MANAGER_STOP, null);
                    }
                }
            }
        }
    }

    private GemFireCacheImpl getGemFireCacheImpl() {
        return (GemFireCacheImpl)this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createManager() {
        Map map = instances;
        synchronized (map) {
            if (this.federatingManager != null) {
                return false;
            }
            this.system.handleResourceEvent(ResourceEvent.MANAGER_CREATE, null);
            this.federatingManager = new FederatingManager(this.jmxAdapter, this.repo, this.system, this, this.cache);
            this.getGemFireCacheImpl().getJmxManagerAdvisor().broadcastChange();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopManager() {
        Map map = instances;
        synchronized (map) {
            this.verifyManagementService();
            if (this.federatingManager != null) {
                this.federatingManager.stopManager();
                this.system.handleResourceEvent(ResourceEvent.MANAGER_STOP, null);
                this.getGemFireCacheImpl().getJmxManagerAdvisor().broadcastChange();
                if (this.agent != null && (this.agent.isRunning() || this.agent.isHttpServiceRunning())) {
                    this.agent.stopAgent();
                }
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public DistributedLockServiceMXBean getDistributedLockServiceMXBean(String lockServiceName) {
        return this.jmxAdapter.getDistributedLockServiceMXBean(lockServiceName);
    }

    @Override
    public DistributedRegionMXBean getDistributedRegionMXBean(String regionName) {
        return this.jmxAdapter.getDistributedRegionMXBean(regionName);
    }

    @Override
    public DistributedSystemMXBean getDistributedSystemMXBean() {
        return this.jmxAdapter.getDistributedSystemMXBean();
    }

    public void addProxyListener(ProxyListener listener) {
        this.proxyListeners.add(listener);
    }

    public void removeProxyListener(ProxyListener listener) {
        this.proxyListeners.remove(listener);
    }

    public List<ProxyListener> getProxyListeners() {
        return this.proxyListeners;
    }

    @Override
    public ManagerMXBean getManagerMXBean() {
        return this.jmxAdapter.getManagerMXBean();
    }

    @Override
    public ObjectName getCacheServerMBeanName(int serverPort, DistributedMember member) {
        return MBeanJMXAdapter.getClientServiceMBeanName(serverPort, member);
    }

    @Override
    public ObjectName getDiskStoreMBeanName(DistributedMember member, String diskName) {
        return MBeanJMXAdapter.getDiskStoreMBeanName(member, diskName);
    }

    @Override
    public ObjectName getDistributedLockServiceMBeanName(String lockService) {
        return MBeanJMXAdapter.getDistributedLockServiceName(lockService);
    }

    @Override
    public ObjectName getDistributedRegionMBeanName(String regionPath) {
        return MBeanJMXAdapter.getDistributedRegionMbeanName(regionPath);
    }

    @Override
    public ObjectName getDistributedSystemMBeanName() {
        return MBeanJMXAdapter.getDistributedSystemName();
    }

    @Override
    public ObjectName getGatewayReceiverMBeanName(DistributedMember member) {
        return MBeanJMXAdapter.getGatewayReceiverMBeanName(member);
    }

    @Override
    public ObjectName getGatewaySenderMBeanName(DistributedMember member, String gatwaySenderId) {
        return MBeanJMXAdapter.getGatewaySenderMBeanName(member, gatwaySenderId);
    }

    @Override
    public ObjectName getAsyncEventQueueMBeanName(DistributedMember member, String queueId) {
        return MBeanJMXAdapter.getAsycnEventQueueMBeanName(member, queueId);
    }

    @Override
    public ObjectName getLockServiceMBeanName(DistributedMember member, String lockServiceName) {
        return MBeanJMXAdapter.getLockServiceMBeanName(member, lockServiceName);
    }

    @Override
    public ObjectName getManagerMBeanName() {
        return MBeanJMXAdapter.getManagerName();
    }

    @Override
    public ObjectName getMemberMBeanName(DistributedMember member) {
        return MBeanJMXAdapter.getMemberMBeanName(member);
    }

    @Override
    public ObjectName getRegionMBeanName(DistributedMember member, String regionPath) {
        return MBeanJMXAdapter.getRegionMBeanName(member, regionPath);
    }

    @Override
    public GatewayReceiverMXBean getLocalGatewayReceiverMXBean() {
        return this.jmxAdapter.getGatewayReceiverMXBean();
    }

    @Override
    public GatewaySenderMXBean getLocalGatewaySenderMXBean(String senderId) {
        return this.jmxAdapter.getGatewaySenderMXBean(senderId);
    }

    @Override
    public AsyncEventQueueMXBean getLocalAsyncEventQueueMXBean(String queueId) {
        return this.jmxAdapter.getAsyncEventQueueMXBean(queueId);
    }

    @Override
    public ObjectName getLocatorMBeanName(DistributedMember member) {
        return MBeanJMXAdapter.getLocatorMBeanName(member);
    }

    @Override
    public LocatorMXBean getLocalLocatorMXBean() {
        return this.jmxAdapter.getLocatorMXBean();
    }

    public boolean afterCreateProxy(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal) {
        for (ProxyListener listener : this.proxyListeners) {
            listener.afterCreateProxy(objectName, interfaceClass, proxyObject, newVal);
        }
        return true;
    }

    public boolean afterPseudoCreateProxy(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal) {
        for (ProxyListener listener : this.proxyListeners) {
            listener.afterPseudoCreateProxy(objectName, interfaceClass, proxyObject, newVal);
        }
        return true;
    }

    public boolean afterRemoveProxy(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent oldVal) {
        for (ProxyListener listener : this.proxyListeners) {
            listener.afterRemoveProxy(objectName, interfaceClass, proxyObject, oldVal);
        }
        return true;
    }

    public boolean afterUpdateProxy(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal, FederationComponent oldVal) {
        for (ProxyListener listener : this.proxyListeners) {
            listener.afterUpdateProxy(objectName, interfaceClass, proxyObject, newVal, oldVal);
        }
        return true;
    }

    public void handleNotification(Notification notification) {
        for (ProxyListener listener : this.proxyListeners) {
            listener.handleNotification(notification);
        }
    }

    @Override
    public <T> T getMBeanInstance(ObjectName objectName, Class<T> interfaceClass) {
        if (this.jmxAdapter.isLocalMBean(objectName)) {
            return this.jmxAdapter.findMBeanByName(objectName, interfaceClass);
        }
        return this.getMBeanProxy(objectName, interfaceClass);
    }

    public void logFine(String s) {
        if (logger.isDebugEnabled()) {
            logger.debug(s);
        }
    }

    public void memberJoined(InternalDistributedMember id) {
        for (ProxyListener listener : this.proxyListeners) {
            listener.memberJoined(id);
        }
    }

    public void memberDeparted(InternalDistributedMember id, boolean crashed) {
        for (ProxyListener listener : this.proxyListeners) {
            listener.memberDeparted(id, crashed);
        }
    }

    public void memberSuspect(InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
        for (ProxyListener listener : this.proxyListeners) {
            listener.memberSuspect(id, whoSuspected, reason);
        }
    }

    public void quorumLost(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
        for (ProxyListener listener : this.proxyListeners) {
            listener.quorumLost(failures, remaining);
        }
    }

    public UniversalListenerContainer getUniversalListenerContainer() {
        return this.universalListenerContainer;
    }

    @Override
    public void addMembershipListener(MembershipListener listener) {
        this.universalListenerContainer.addMembershipListener(listener);
    }

    @Override
    public void removeMembershipListener(MembershipListener listener) {
        this.universalListenerContainer.removeMembershipListener(listener);
    }

    public class UniversalListenerContainer {
        private List<MembershipListener> membershipListeners = new CopyOnWriteArrayList<MembershipListener>();

        public void memberJoined(InternalDistributedMember id) {
            MembershipEvent event = this.createEvent(id);
            for (MembershipListener listener : this.membershipListeners) {
                try {
                    listener.memberJoined(event);
                }
                catch (Exception e) {
                    logger.error("Could not invoke listener event memberJoined for listener[{}] due to ", new Object[]{listener.getClass(), e.getMessage(), e});
                }
            }
        }

        public void memberDeparted(InternalDistributedMember id, boolean crashed) {
            MembershipEvent event = this.createEvent(id);
            if (!crashed) {
                for (MembershipListener listener : this.membershipListeners) {
                    try {
                        listener.memberLeft(event);
                    }
                    catch (Exception e) {
                        logger.error("Could not invoke listener event memberLeft for listener[{}] due to ", new Object[]{listener.getClass(), e.getMessage(), e});
                    }
                }
            } else {
                for (MembershipListener listener : this.membershipListeners) {
                    try {
                        listener.memberCrashed(event);
                    }
                    catch (Exception e) {
                        logger.error("Could not invoke listener event memberCrashed for listener[{}] due to ", new Object[]{listener.getClass(), e.getMessage(), e});
                    }
                }
            }
        }

        private MembershipEvent createEvent(InternalDistributedMember id) {
            final String memberId = id.getId();
            final InternalDistributedMember member = id;
            MembershipEvent event = new MembershipEvent(){

                @Override
                public String getMemberId() {
                    return memberId;
                }

                @Override
                public DistributedMember getDistributedMember() {
                    return member;
                }
            };
            return event;
        }

        public void addMembershipListener(MembershipListener listener) {
            this.membershipListeners.add(listener);
        }

        public void removeMembershipListener(MembershipListener listener) {
            this.membershipListeners.remove(listener);
        }
    }
}

