/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal;

import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.management.internal.MBeanProxyFactory;
import com.gemstone.gemfire.management.internal.NotificationBroadCasterProxy;
import com.gemstone.gemfire.management.internal.NotificationKey;
import javax.management.Notification;
import org.apache.logging.log4j.Logger;

public class NotificationHubClient {
    private static final Logger logger = LogService.getLogger();
    private MBeanProxyFactory proxyFactory;

    protected NotificationHubClient(MBeanProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    public void sendNotification(EntryEvent<NotificationKey, Notification> event) {
        try {
            NotificationBroadCasterProxy notifBroadCaster = this.proxyFactory.findProxy(event.getKey().getObjectName(), NotificationBroadCasterProxy.class);
            if (notifBroadCaster != null) {
                notifBroadCaster.sendNotification(event.getNewValue());
            }
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug(" NOTIFICATION Not Done {}", new Object[]{e.getMessage(), e});
            }
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }
}

