/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal;

import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.internal.ClassLoadUtil;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.management.internal.FederationComponent;
import com.gemstone.gemfire.management.internal.SystemManagementService;
import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import org.apache.logging.log4j.Logger;

public class MonitoringRegionCacheListener
extends CacheListenerAdapter<String, Object> {
    private static final Logger logger = LogService.getLogger();
    private SystemManagementService service;
    private Map<String, Class> classRef = new HashMap<String, Class>();
    private static final String THIS_COMPONENT = MonitoringRegionCacheListener.class.getName();

    public MonitoringRegionCacheListener(SystemManagementService service) {
        this.service = service;
    }

    @Override
    public void afterUpdate(EntryEvent<String, Object> event) {
        block5: {
            ObjectName objectName = null;
            try {
                Class interfaceClass;
                if (!this.service.isStartedAndOpen() || !this.service.isManager()) {
                    return;
                }
                objectName = ObjectName.getInstance(event.getKey());
                FederationComponent oldObject = (FederationComponent)event.getOldValue();
                FederationComponent newObject = (FederationComponent)event.getNewValue();
                String className = newObject.getMBeanInterfaceClass();
                if (this.classRef.get(className) != null) {
                    interfaceClass = this.classRef.get(className);
                } else {
                    interfaceClass = ClassLoadUtil.classFromName(className);
                    this.classRef.put(className, interfaceClass);
                }
                this.service.afterUpdateProxy(objectName, interfaceClass, null, newObject, oldObject);
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug("Aggregation Failed failed for {} with exception {}", (Throwable)e);
            }
        }
    }

    @Override
    public void afterCreate(EntryEvent<String, Object> event) {
        block5: {
            ObjectName objectName = null;
            try {
                Class interfaceClass;
                if (!this.service.isStartedAndOpen() || !this.service.isManager()) {
                    return;
                }
                objectName = ObjectName.getInstance(event.getKey());
                FederationComponent newObject = (FederationComponent)event.getNewValue();
                String className = newObject.getMBeanInterfaceClass();
                if (this.classRef.get(className) != null) {
                    interfaceClass = this.classRef.get(className);
                } else {
                    interfaceClass = ClassLoadUtil.classFromName(className);
                    this.classRef.put(className, interfaceClass);
                }
                this.service.afterPseudoCreateProxy(objectName, interfaceClass, null, newObject);
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug("{}: Aggregation Failed failed for {} With Exception {}", new Object[]{THIS_COMPONENT, objectName, e});
            }
        }
    }
}

