/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal;

import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.admin.remote.AlertLevelChangeMessage;
import com.gemstone.gemfire.internal.logging.LogWriterImpl;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.gemstone.gemfire.management.internal.ManagementResourceRepo;
import com.gemstone.gemfire.management.internal.ManagerStartupMessage;
import java.util.Set;

public class MemberMessenger {
    private MBeanJMXAdapter jmxAdapter;
    private ManagementResourceRepo repo;
    private InternalDistributedSystem system;

    public MemberMessenger(MBeanJMXAdapter jmxAdapter, ManagementResourceRepo repo, InternalDistributedSystem system) {
        this.jmxAdapter = jmxAdapter;
        this.repo = repo;
        this.system = system;
    }

    public void sendManagerInfo(DistributedMember receiver) {
        String levelName = this.jmxAdapter.getDistributedSystemMXBean().getAlertLevel();
        int alertCode = LogWriterImpl.levelNameToCode(levelName);
        ManagerStartupMessage msg = ManagerStartupMessage.create(alertCode);
        msg.setRecipient((InternalDistributedMember)receiver);
        this.sendAsync(msg);
    }

    public void broadcastManagerInfo() {
        Set otherMemberSet = this.system.getDistributionManager().getAllOtherMembers();
        String levelName = this.jmxAdapter.getDistributedSystemMXBean().getAlertLevel();
        int alertCode = LogWriterImpl.levelNameToCode(levelName);
        ManagerStartupMessage msg = ManagerStartupMessage.create(alertCode);
        if (otherMemberSet != null && otherMemberSet.size() > 0) {
            msg.setRecipients(otherMemberSet);
        }
        this.sendAsync(msg);
        DM dm = this.system.getDistributionManager();
        if (dm instanceof DistributionManager) {
            msg.process((DistributionManager)this.system.getDistributionManager());
        }
    }

    void sendAsync(DistributionMessage msg) {
        if (this.system != null) {
            this.system.getDistributionManager().putOutgoing(msg);
        }
    }

    public void setAlertLevel(String levelName) {
        int alertCode = LogWriterImpl.levelNameToCode(levelName);
        AlertLevelChangeMessage m = AlertLevelChangeMessage.create(alertCode);
        this.sendAsync(m);
    }
}

