/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal;

import com.gemstone.gemfire.distributed.internal.MembershipListener;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.management.internal.SystemManagementService;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class ManagementMembershipListener
implements MembershipListener {
    private static final Logger logger = LogService.getLogger();
    private SystemManagementService service;

    public ManagementMembershipListener(SystemManagementService service) {
        this.service = service;
    }

    @Override
    public void memberDeparted(InternalDistributedMember id, boolean crashed) {
        if (logger.isDebugEnabled()) {
            logger.debug("ManagementMembershipListener member departed.. {}", new Object[]{id.getId()});
        }
        if (this.service.isManager()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Removing member artifacts for {} from manager ", new Object[]{id.getId()});
            }
            this.service.getFederatingManager().removeMember(id, crashed);
        }
        this.service.getUniversalListenerContainer().memberDeparted(id, crashed);
    }

    @Override
    public void memberJoined(InternalDistributedMember id) {
        if (logger.isDebugEnabled()) {
            logger.debug("ManagementMembershipListener member joined .. {}", new Object[]{id.getId()});
        }
        if (this.service.isManager()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Adding member artifacts for {} to manager ", new Object[]{id.getId()});
            }
            this.service.getFederatingManager().addMember(id);
        }
        this.service.getUniversalListenerContainer().memberJoined(id);
    }

    @Override
    public void memberSuspect(InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
        if (logger.isDebugEnabled()) {
            logger.debug("ManagementMembershipListener member suspected .. {}", new Object[]{id.getId()});
        }
        if (this.service.isManager()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Suspecting member {}", new Object[]{id.getId()});
            }
            this.service.getFederatingManager().suspectMember(id, whoSuspected, reason);
        }
    }

    @Override
    public void quorumLost(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
    }
}

