/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal;

import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.gemstone.gemfire.management.internal.ManagementConstants;
import com.gemstone.gemfire.management.internal.ManagementStrings;
import com.gemstone.gemfire.management.internal.NotificationHub;
import java.io.Serializable;
import javax.management.Attribute;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.logging.log4j.Logger;

public class ManagementFunction
extends FunctionAdapter
implements InternalEntity {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 1L;
    private MBeanServer mbeanServer = MBeanJMXAdapter.mbeanServer;
    private NotificationHub notificationHub;

    public ManagementFunction(NotificationHub notifHub) {
        this.notificationHub = notifHub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(FunctionContext fc) {
        block24: {
            boolean executedSuccessfully = false;
            GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
            Object[] functionArguments = (Object[])fc.getArguments();
            ObjectName objectName = (ObjectName)functionArguments[0];
            String methodName = (String)functionArguments[1];
            String[] signature = (String[])functionArguments[2];
            Object[] args = (Object[])functionArguments[3];
            String memberName = (String)functionArguments[4];
            Object returnObj = null;
            try {
                int nargs;
                int n = nargs = args == null ? 0 : args.length;
                if (methodName.startsWith("set") && methodName.length() > 3 && nargs == 1) {
                    Attribute attr = new Attribute(methodName.substring(3), args[0]);
                    this.mbeanServer.setAttribute(objectName, attr);
                    fc.getResultSender().lastResult(null);
                } else if (methodName.equals("addNotificationListener")) {
                    this.notificationHub.addHubNotificationListener(memberName, objectName);
                    fc.getResultSender().lastResult("UNDEFINED");
                } else if (methodName.equals("removeNotificationListener")) {
                    this.notificationHub.removeHubNotificationListener(memberName, objectName);
                    fc.getResultSender().lastResult("UNDEFINED");
                } else if (methodName.equals("getNotificationInfo")) {
                    fc.getResultSender().lastResult(this.mbeanServer.getMBeanInfo(objectName));
                } else {
                    returnObj = this.mbeanServer.invoke(objectName, methodName, args, signature);
                    fc.getResultSender().lastResult((Serializable)returnObj);
                }
                executedSuccessfully = true;
            }
            catch (InstanceNotFoundException e) {
                if (cache != null) {
                    if (!cache.isClosed()) {
                        this.sendException(e, fc);
                    }
                }
            }
            catch (ReflectionException e) {
                this.sendException(e, fc);
            }
            catch (MBeanException e) {
                this.sendException(e, fc);
            }
            catch (NullPointerException e) {
                this.sendException(e, fc);
            }
            catch (Exception e) {
                this.sendException(e, fc);
            }
            finally {
                if (executedSuccessfully || cache != null && (cache == null || !cache.isClosed())) break block24;
                e = new Exception(ManagementStrings.MEMBER_IS_SHUTTING_DOWN.toLocalizedString());
                this.sendException(e, fc);
                return;
            }
        }
    }

    @Override
    public String getId() {
        return ManagementConstants.MGMT_FUNCTION_ID;
    }

    private void sendException(Exception e, FunctionContext fc) {
        if (logger.isDebugEnabled()) {
            logger.debug(ManagementStrings.MANAGEMENT_FUNCTION_COULD_NOT_EXECUTE.toLocalizedString());
            logger.debug(e.getMessage(), (Throwable)e);
        }
        fc.getResultSender().sendException(e);
    }
}

