/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal;

import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.management.internal.MBeanProxyFactory;
import com.gemstone.gemfire.management.internal.ProxyInfo;
import com.gemstone.gemfire.management.internal.ProxyInterface;
import javax.management.ObjectName;
import org.apache.logging.log4j.Logger;

public class ManagementCacheListener
extends CacheListenerAdapter<String, Object> {
    private static final Logger logger = LogService.getLogger();
    private MBeanProxyFactory proxyHelper;
    private volatile boolean readyForEvents;

    public ManagementCacheListener(MBeanProxyFactory proxyHelper) {
        this.proxyHelper = proxyHelper;
        this.readyForEvents = false;
    }

    @Override
    public void afterCreate(EntryEvent<String, Object> event) {
        block3: {
            if (!this.readyForEvents) {
                return;
            }
            ObjectName objectName = null;
            try {
                objectName = ObjectName.getInstance(event.getKey());
                Object newObject = event.getNewValue();
                this.proxyHelper.createProxy(event.getDistributedMember(), objectName, event.getRegion(), newObject);
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("Proxy Create failed for {} with exception {}", new Object[]{objectName, e.getMessage(), e});
            }
        }
    }

    @Override
    public void afterDestroy(EntryEvent<String, Object> event) {
        block2: {
            ObjectName objectName = null;
            try {
                objectName = ObjectName.getInstance(event.getKey());
                Object oldObject = event.getOldValue();
                this.proxyHelper.removeProxy(event.getDistributedMember(), objectName, oldObject);
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Proxy Destroy failed for {} with exception {}", new Object[]{objectName, e.getMessage(), e});
            }
        }
    }

    @Override
    public void afterUpdate(EntryEvent<String, Object> event) {
        block5: {
            ObjectName objectName = null;
            try {
                if (!this.readyForEvents) {
                    return;
                }
                objectName = ObjectName.getInstance(event.getKey());
                ProxyInfo proxyInfo = this.proxyHelper.findProxyInfo(objectName);
                if (proxyInfo != null) {
                    ProxyInterface proxyObj = (ProxyInterface)proxyInfo.getProxyInstance();
                    if (proxyObj != null) {
                        proxyObj.setLastRefreshedTime(System.currentTimeMillis());
                    }
                    Object oldObject = event.getOldValue();
                    Object newObject = event.getNewValue();
                    this.proxyHelper.updateProxy(objectName, proxyInfo, newObject, oldObject);
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug("Proxy Update failed for {} with exception {}", new Object[]{objectName, e.getMessage(), e});
            }
        }
    }

    void markReady() {
        this.readyForEvents = true;
    }
}

