/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.HasCachePerfStats;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.management.ManagementException;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.gemstone.gemfire.management.internal.MBeanProxyFactory;
import com.gemstone.gemfire.management.internal.ManagementCacheListener;
import com.gemstone.gemfire.management.internal.ManagementResourceRepo;
import com.gemstone.gemfire.management.internal.Manager;
import com.gemstone.gemfire.management.internal.MemberMessenger;
import com.gemstone.gemfire.management.internal.NotificationCacheListener;
import com.gemstone.gemfire.management.internal.NotificationKey;
import com.gemstone.gemfire.management.internal.RemoteFilterChain;
import com.gemstone.gemfire.management.internal.SystemManagementService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import javax.management.Notification;
import javax.management.ObjectName;
import org.apache.logging.log4j.Logger;

public class FederatingManager
extends Manager {
    public static final Logger logger = LogService.getLogger();
    private ExecutorService pooledMembershipExecutor;
    protected MBeanProxyFactory proxyFactory;
    private RemoteFilterChain remoteFilterChain = new RemoteFilterChain();
    private MBeanJMXAdapter jmxAdapter;
    private MemberMessenger messenger;
    private SystemManagementService service;

    public FederatingManager(MBeanJMXAdapter jmxAdapter, ManagementResourceRepo repo, InternalDistributedSystem system, SystemManagementService service, Cache cache) {
        super(repo, system, cache);
        this.service = service;
        this.proxyFactory = new MBeanProxyFactory(this.remoteFilterChain, jmxAdapter, service);
        this.jmxAdapter = jmxAdapter;
        this.messenger = new MemberMessenger(jmxAdapter, repo, system);
    }

    @Override
    public synchronized void startManager() {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Starting the Federating Manager.... ");
            }
            Runtime rt = Runtime.getRuntime();
            this.pooledMembershipExecutor = Executors.newFixedThreadPool(rt.availableProcessors());
            this.running = true;
            this.startManagingActivity();
            this.messenger.broadcastManagerInfo();
        }
        catch (InterruptedException e) {
            this.running = false;
            throw new ManagementException(e);
        }
        catch (Exception e) {
            this.running = false;
            throw new ManagementException(e);
        }
    }

    @Override
    public synchronized void stopManager() {
        if (!this.running) {
            return;
        }
        this.running = false;
        if (logger.isDebugEnabled()) {
            logger.debug("Stopping the Federating Manager.... ");
        }
        this.stopManagingActivity();
    }

    private void stopManagingActivity() {
        try {
            this.pooledMembershipExecutor.shutdownNow();
            Iterator<DistributedMember> it = this.repo.getMonitoringRegionMap().keySet().iterator();
            while (it.hasNext()) {
                this.removeMemberArtifacts(it.next(), false);
            }
        }
        catch (Exception e) {
            throw new ManagementException(e);
        }
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    public void addMember(DistributedMember member) {
        GIITask giiTask = new GIITask(member);
        this.submitTask(giiTask);
    }

    public void removeMember(DistributedMember member, boolean crashed) {
        RemoveMemberTask removeTask = new RemoveMemberTask(member, crashed);
        this.submitTask(removeTask);
    }

    private void submitTask(Callable<DistributedMember> task) {
        try {
            this.pooledMembershipExecutor.submit(task);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    private DistributedMember removeMemberArtifacts(DistributedMember member, boolean crashed) {
        Region<String, Object> proxyRegion = this.repo.getEntryFromMonitoringRegionMap(member);
        Region<NotificationKey, Notification> notifRegion = this.repo.getEntryFromNotifRegionMap(member);
        if (proxyRegion == null && notifRegion == null) {
            return member;
        }
        this.repo.romoveEntryFromMonitoringRegionMap(member);
        this.repo.removeEntryFromNotifRegionMap(member);
        if (!this.cache.isClosed()) {
            this.proxyFactory.removeAllProxies(member, proxyRegion);
            proxyRegion.localDestroyRegion();
            notifRegion.localDestroyRegion();
        }
        if (!this.cache.getDistributedSystem().getDistributedMember().equals(member)) {
            this.service.memberDeparted((InternalDistributedMember)member, crashed);
        }
        return member;
    }

    public void suspectMember(DistributedMember member, InternalDistributedMember whoSuspected, String reason) {
        this.service.memberSuspect((InternalDistributedMember)member, whoSuspected, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startManagingActivity() throws Exception {
        boolean isDebugEnabled = logger.isDebugEnabled();
        Set members = this.cache.getDistributionManager().getOtherDistributionManagerIds();
        Iterator it = members.iterator();
        ArrayList<GIITask> giiTaskList = new ArrayList<GIITask>();
        while (it.hasNext()) {
            DistributedMember member = (DistributedMember)it.next();
            giiTaskList.add(new GIITask(member));
        }
        try {
            if (isDebugEnabled) {
                logger.debug("Management Resource creation started  : ");
            }
            List futureTaskList = this.pooledMembershipExecutor.invokeAll(giiTaskList);
            for (Future futureTask : futureTaskList) {
                String memberId = null;
                try {
                    DistributedMember returnedMember = (DistributedMember)futureTask.get();
                    if (returnedMember != null) {
                        memberId = returnedMember.getId();
                    }
                    if (futureTask.isDone() && isDebugEnabled) {
                        logger.debug("Monitoring Resource Created for : {}", new Object[]{memberId});
                    }
                    if (!futureTask.isCancelled() || !isDebugEnabled) continue;
                    logger.debug("Monitoring resource Creation Failed for : {}", new Object[]{memberId});
                }
                catch (ExecutionException e) {
                    if (!isDebugEnabled) continue;
                    logger.debug("ExecutionException during Management GII: {}", new Object[]{e.getMessage(), e});
                }
                catch (CancellationException e) {
                    if (!isDebugEnabled) continue;
                    ManagementException mgEx = new ManagementException(e.fillInStackTrace());
                    logger.debug("InterruptedException while creating Monitoring resource with error : {}", new Object[]{mgEx.getMessage(), mgEx});
                }
            }
        }
        catch (InterruptedException e) {
            if (isDebugEnabled) {
                ManagementException mgEx = new ManagementException(e.fillInStackTrace());
                logger.debug("InterruptedException while creating Monitoring resource with error : ", new Object[]{mgEx.getMessage(), mgEx});
            }
        }
        finally {
            if (isDebugEnabled) {
                logger.debug("Management Resource creation completed");
            }
        }
    }

    public MBeanProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    public long getLastUpdateTime(ObjectName objectName) {
        return this.proxyFactory.getLastUpdateTime(objectName);
    }

    public <T> T findProxy(ObjectName objectName, Class<T> interfaceClass) {
        return this.proxyFactory.findProxy(objectName, interfaceClass);
    }

    public Set<ObjectName> findAllProxies(DistributedMember member) {
        return this.proxyFactory.findAllProxies(member);
    }

    public MemberMessenger getMessenger() {
        return this.messenger;
    }

    private class GIITask
    implements Callable<DistributedMember> {
        private DistributedMember member;

        protected GIITask(DistributedMember member) {
            this.member = member;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public DistributedMember call() {
            block23: {
                Region<String, Object> proxyMonitoringRegion = null;
                Region<NotificationKey, Notification> proxyNotificationgRegion = null;
                boolean proxyCreatedForMember = false;
                try {
                    if (Thread.currentThread().isInterrupted()) break block23;
                    InternalRegionArguments internalArgs = new InternalRegionArguments();
                    internalArgs.setIsUsedForMetaRegion(true);
                    HasCachePerfStats monitoringRegionStats = new HasCachePerfStats(){

                        @Override
                        public CachePerfStats getCachePerfStats() {
                            return new CachePerfStats(FederatingManager.this.cache.getDistributedSystem(), "managementRegionStats");
                        }
                    };
                    internalArgs.setCachePerfStatsHolder(monitoringRegionStats);
                    AttributesFactory<String, Object> monitorAttrFactory = new AttributesFactory<String, Object>();
                    monitorAttrFactory.setScope(Scope.DISTRIBUTED_NO_ACK);
                    monitorAttrFactory.setDataPolicy(DataPolicy.REPLICATE);
                    monitorAttrFactory.setConcurrencyChecksEnabled(false);
                    ManagementCacheListener mgmtCacheListener = new ManagementCacheListener(FederatingManager.this.proxyFactory);
                    monitorAttrFactory.addCacheListener(mgmtCacheListener);
                    RegionAttributes monitoringRegionAttrs = monitorAttrFactory.create();
                    AttributesFactory<NotificationKey, Notification> notifAttrFactory = new AttributesFactory<NotificationKey, Notification>();
                    notifAttrFactory.setScope(Scope.DISTRIBUTED_NO_ACK);
                    notifAttrFactory.setDataPolicy(DataPolicy.REPLICATE);
                    notifAttrFactory.setConcurrencyChecksEnabled(false);
                    notifAttrFactory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes(10, EvictionAction.LOCAL_DESTROY));
                    NotificationCacheListener notifListener = new NotificationCacheListener(FederatingManager.this.proxyFactory);
                    notifAttrFactory.addCacheListener(notifListener);
                    RegionAttributes notifRegionAttrs = notifAttrFactory.create();
                    boolean proxyMonitoringRegionCreated = false;
                    boolean proxyNotifRegionCreated = false;
                    String appender = MBeanJMXAdapter.getUniqueIDForMember(this.member);
                    try {
                        if (!FederatingManager.this.running) {
                            return null;
                        }
                        proxyMonitoringRegion = FederatingManager.this.cache.createVMRegion("_monitoringRegion_" + appender, monitoringRegionAttrs, internalArgs);
                        proxyMonitoringRegionCreated = true;
                    }
                    catch (TimeoutException e) {
                        if (!logger.isDebugEnabled()) throw new ManagementException(e);
                        logger.debug("Error During Internal Region creation {}", new Object[]{e.getMessage(), e});
                        throw new ManagementException(e);
                    }
                    catch (RegionExistsException e) {
                        if (!logger.isDebugEnabled()) throw new ManagementException(e);
                        logger.debug("Error During Internal Region creation {}", new Object[]{e.getMessage(), e});
                        throw new ManagementException(e);
                    }
                    catch (IOException e) {
                        if (!logger.isDebugEnabled()) throw new ManagementException(e);
                        logger.debug("Error During Internal Region creation {}", new Object[]{e.getMessage(), e});
                        throw new ManagementException(e);
                    }
                    catch (ClassNotFoundException e) {
                        if (!logger.isDebugEnabled()) throw new ManagementException(e);
                        logger.debug("Error During Internal Region creation {}", new Object[]{e.getMessage(), e});
                        throw new ManagementException(e);
                    }
                    try {
                        if (!FederatingManager.this.running) {
                            DistributedMember e = null;
                            return e;
                        }
                        proxyNotificationgRegion = FederatingManager.this.cache.createVMRegion("_notificationRegion_" + appender, notifRegionAttrs, internalArgs);
                        proxyNotifRegionCreated = true;
                    }
                    catch (TimeoutException e) {
                        if (!logger.isDebugEnabled()) throw new ManagementException(e);
                        logger.debug("Error During Internal Region creation {}", new Object[]{e.getMessage(), e});
                        throw new ManagementException(e);
                    }
                    catch (RegionExistsException e) {
                        if (!logger.isDebugEnabled()) throw new ManagementException(e);
                        logger.debug("Error During Internal Region creation {}", new Object[]{e.getMessage(), e});
                        throw new ManagementException(e);
                    }
                    catch (IOException e) {
                        if (!logger.isDebugEnabled()) throw new ManagementException(e);
                        logger.debug("Error During Internal Region creation {}", new Object[]{e.getMessage(), e});
                        throw new ManagementException(e);
                    }
                    catch (ClassNotFoundException e) {
                        if (!logger.isDebugEnabled()) throw new ManagementException(e);
                        logger.debug("Error During Internal Region creation {}", new Object[]{e.getMessage(), e});
                        throw new ManagementException(e);
                    }
                    finally {
                        if (!proxyNotifRegionCreated && proxyMonitoringRegionCreated) {
                            proxyMonitoringRegion.localDestroyRegion();
                        }
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Management Region created with Name : {}", new Object[]{proxyMonitoringRegion.getName()});
                        logger.debug("Notification Region created with Name : {}", new Object[]{proxyNotificationgRegion.getName()});
                    }
                    FederatingManager.this.repo.putEntryInMonitoringRegionMap(this.member, proxyMonitoringRegion);
                    FederatingManager.this.repo.putEntryInNotifRegionMap(this.member, proxyNotificationgRegion);
                    try {
                        if (!FederatingManager.this.running) {
                            return null;
                        }
                        FederatingManager.this.proxyFactory.createAllProxies(this.member, proxyMonitoringRegion);
                        proxyCreatedForMember = true;
                        mgmtCacheListener.markReady();
                        notifListener.markReady();
                    }
                    catch (Exception e) {
                        if (!logger.isDebugEnabled()) throw new ManagementException(e);
                        logger.debug("Error During GII Proxy creation {}", new Object[]{e.getMessage(), e});
                        throw new ManagementException(e);
                    }
                }
                catch (Exception e) {
                    throw new ManagementException(e);
                }
            }
            FederatingManager.this.service.memberJoined((InternalDistributedMember)this.member);
            FederatingManager.this.messenger.sendManagerInfo(this.member);
            return this.member;
        }
    }

    private class RemoveMemberTask
    implements Callable<DistributedMember> {
        private DistributedMember member;
        boolean crashed;

        protected RemoveMemberTask(DistributedMember member, boolean crashed) {
            this.member = member;
            this.crashed = crashed;
        }

        @Override
        public DistributedMember call() {
            return FederatingManager.this.removeMemberArtifacts(this.member, this.crashed);
        }
    }
}

