/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.internal.SystemManagementService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;

public abstract class BaseManagementService
extends ManagementService {
    private static final Logger logger = LogService.getLogger();
    protected static final Map<Object, BaseManagementService> instances = new HashMap<Object, BaseManagementService>();
    private static final List<InternalDistributedSystem> systems = new ArrayList<InternalDistributedSystem>(1);

    protected BaseManagementService() {
    }

    protected abstract void close();

    protected abstract boolean isClosed();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ManagementService getManagementService(Cache cache) {
        Map<Object, BaseManagementService> map = instances;
        synchronized (map) {
            BaseManagementService service = instances.get(cache);
            if (service == null) {
                service = SystemManagementService.newSystemManagementService(cache);
                instances.put(cache, service);
            }
            return service;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ManagementService getExistingManagementService(Cache cache) {
        Map<Object, BaseManagementService> map = instances;
        synchronized (map) {
            BaseManagementService service = instances.get(cache);
            return service;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initInternalDistributedSystem() {
        Map<Object, BaseManagementService> map = instances;
        synchronized (map) {
            List existingSystems = InternalDistributedSystem.addConnectListener(new InternalDistributedSystem.ConnectListener(){

                @Override
                public void onConnect(InternalDistributedSystem sys) {
                    BaseManagementService.addInternalDistributedSystem(sys);
                }
            });
            for (InternalDistributedSystem sys : existingSystems) {
                try {
                    if (!sys.isConnected()) continue;
                    BaseManagementService.addInternalDistributedSystem(sys);
                }
                catch (DistributedSystemDisconnectedException e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("DistributedSystemDisconnectedException {}", new Object[]{e.getMessage(), e});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addInternalDistributedSystem(InternalDistributedSystem sys) {
        Map<Object, BaseManagementService> map = instances;
        synchronized (map) {
            sys.addDisconnectListener(new InternalDistributedSystem.DisconnectListener(){

                public String toString() {
                    return "Disconnect listener for BaseManagementService";
                }

                @Override
                public void onDisconnect(InternalDistributedSystem ss) {
                    BaseManagementService.removeInternalDistributedSystem(ss);
                }
            });
            systems.add(sys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeInternalDistributedSystem(InternalDistributedSystem sys) {
        Map<Object, BaseManagementService> map = instances;
        synchronized (map) {
            systems.remove(sys);
            if (systems.isEmpty()) {
                for (Object key : instances.keySet()) {
                    BaseManagementService service = instances.get(key);
                    try {
                        if (service.isClosed()) continue;
                        service.close();
                    }
                    catch (Exception e) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("ManagementException while removing InternalDistributedSystem {}", new Object[]{e.getMessage(), e});
                    }
                }
                instances.clear();
            }
        }
    }

    static {
        BaseManagementService.initInternalDistributedSystem();
    }
}

