/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.util.concurrent;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.util.concurrent.StoppableCountDownLatch;

public class StoppableCountDownOrUpLatch {
    private int count_;
    private CancelCriterion stopper;
    private static final long NANOS_PER_MS = 1000000L;

    public StoppableCountDownOrUpLatch(CancelCriterion stopper, int count) {
        Assert.assertTrue(stopper != null);
        if (count < 0) {
            throw new IllegalArgumentException(LocalizedStrings.StoppableCountDownOrUpLatch_COUNT_0.toLocalizedString());
        }
        this.stopper = stopper;
        this.count_ = count;
    }

    public void await() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        do {
            this.stopper.checkCancelInProgress(null);
        } while (!this.await(StoppableCountDownLatch.RETRY_TIME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean await(long msTimeout) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        long nanos = msTimeout * 1000000L;
        StoppableCountDownOrUpLatch stoppableCountDownOrUpLatch = this;
        synchronized (stoppableCountDownOrUpLatch) {
            if (this.count_ <= 0) {
                return true;
            }
            if (nanos <= 0L) {
                return false;
            }
            long deadline = System.nanoTime() + nanos;
            do {
                this.stopper.checkCancelInProgress(null);
                this.wait(nanos / 1000000L, (int)(nanos % 1000000L));
                if (this.count_ > 0) continue;
                return true;
            } while ((nanos = deadline - System.nanoTime()) > 0L);
            return false;
        }
    }

    public synchronized void countDown() {
        if (this.count_ == 0) {
            return;
        }
        if (--this.count_ == 0) {
            this.notifyAll();
        }
    }

    public long getCount() {
        return this.count_;
    }

    public String toString() {
        return super.toString() + "[Count = " + this.getCount() + "]";
    }

    public synchronized void countUp() {
        ++this.count_;
    }

    public synchronized long getCountSync() {
        return this.getCount();
    }
}

