/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.util.concurrent;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.internal.Assert;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;

public class StoppableCondition
implements Serializable {
    private static final long serialVersionUID = -7091681525970431937L;
    private final Condition condition;
    private final CancelCriterion stopper;
    private static final long RETRY_TIME = 15000L;

    StoppableCondition(Condition c, CancelCriterion stopper) {
        Assert.assertTrue(stopper != null);
        this.condition = c;
        this.stopper = stopper;
    }

    public void awaitUninterruptibly() {
        while (true) {
            boolean interrupted = Thread.interrupted();
            try {
                this.await();
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            finally {
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    public void await() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        do {
            this.stopper.checkCancelInProgress(null);
        } while (!this.await(15000L));
    }

    public boolean await(long timeoutMs) throws InterruptedException {
        this.stopper.checkCancelInProgress(null);
        return this.condition.await(timeoutMs, TimeUnit.MILLISECONDS);
    }

    public boolean awaitUntil(Date deadline) throws InterruptedException {
        this.stopper.checkCancelInProgress(null);
        return this.condition.awaitUntil(deadline);
    }

    public synchronized void signal() {
        this.condition.signal();
    }

    public synchronized void signalAll() {
        this.condition.signalAll();
    }
}

