/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.util;

import com.gemstone.gemfire.internal.lang.Filter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public abstract class CollectionUtils {
    @SafeVarargs
    public static <T> List<T> asList(T ... array) {
        ArrayList arrayList = new ArrayList(array.length);
        Collections.addAll(arrayList, array);
        return arrayList;
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... array) {
        HashSet arraySet = new HashSet(array.length);
        Collections.addAll(arraySet, array);
        return arraySet;
    }

    public static Properties createProperties(Map<String, String> map) {
        Properties properties = new Properties();
        if (map != null && !map.isEmpty()) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                properties.setProperty(entry.getKey(), entry.getValue());
            }
        }
        return properties;
    }

    public static <T> List<T> emptyList(List<T> list) {
        return list != null ? list : Collections.emptyList();
    }

    public static <T> Set<T> emptySet(Set<T> set) {
        return set != null ? set : Collections.emptySet();
    }

    public static <T> List<T> findAll(Collection<T> collection, Filter<T> filter) {
        ArrayList<T> matches = new ArrayList<T>(collection.size());
        for (T element : collection) {
            if (!filter.accept(element)) continue;
            matches.add(element);
        }
        return matches;
    }

    public static <T> T findBy(Collection<T> collection, Filter<T> filter) {
        for (T element : collection) {
            if (!filter.accept(element)) continue;
            return element;
        }
        return null;
    }

    public static <K, V> Map<K, V> removeKeys(Map<K, V> map, Filter<Map.Entry<K, V>> filter) {
        Iterator<Map.Entry<K, V>> mapEntries = map.entrySet().iterator();
        while (mapEntries.hasNext()) {
            if (filter.accept(mapEntries.next())) continue;
            mapEntries.remove();
        }
        return map;
    }

    public static <K, V> Map<K, V> removeKeysWithNullValues(Map<K, V> map) {
        return CollectionUtils.removeKeys(map, new Filter<Map.Entry<K, V>>(){

            @Override
            public boolean accept(Map.Entry<K, V> entry) {
                return entry.getValue() != null;
            }
        });
    }

    public static final <T> boolean addAll(Collection<T> collection, Enumeration<T> enumeration) {
        if (null == enumeration) {
            return false;
        }
        boolean modified = false;
        while (enumeration.hasMoreElements()) {
            modified |= collection.add(enumeration.nextElement());
        }
        return modified;
    }

    public static final <T> Iterable<T> unmodifiableIterable(Iterable<T> iterable) {
        return new UnmodifiableIterable(iterable);
    }

    private static class UnmodifiableIterable<T>
    implements Iterable<T> {
        private final Iterable<T> iterable;

        private UnmodifiableIterable(Iterable<T> iterable) {
            this.iterable = iterable;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private final Iterator<T> iterator;
                {
                    this.iterator = iterable.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public T next() {
                    return this.iterator.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

