/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.util;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.distributed.internal.DMStats;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.ByteArrayDataInput;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.offheap.StoredObject;
import com.gemstone.gemfire.pdx.internal.PdxInputStream;
import java.io.IOException;

public class BlobHelper {
    public static byte[] serializeToBlob(Object obj) throws IOException {
        return BlobHelper.serializeToBlob(obj, null);
    }

    public static byte[] serializeToBlob(Object obj, Version version) throws IOException {
        long start = BlobHelper.startSerialization();
        HeapDataOutputStream hdos = new HeapDataOutputStream(version);
        DataSerializer.writeObject(obj, hdos);
        byte[] result = hdos.toByteArray();
        BlobHelper.endSerialization(start, result.length);
        return result;
    }

    public static void serializeTo(Object obj, HeapDataOutputStream hdos) throws IOException {
        int startBytes = hdos.size();
        long start = BlobHelper.startSerialization();
        DataSerializer.writeObject(obj, hdos);
        BlobHelper.endSerialization(start, hdos.size() - startBytes);
    }

    public static Object deserializeBlob(byte[] blob) throws IOException, ClassNotFoundException {
        return BlobHelper.deserializeBlob(blob, null, null);
    }

    public static Object deserializeBlob(byte[] blob, Version version, ByteArrayDataInput in) throws IOException, ClassNotFoundException {
        Object result;
        long start = BlobHelper.startDeserialization();
        if (blob.length > 0 && blob[0] == 93) {
            PdxInputStream is = new PdxInputStream(blob);
            result = DataSerializer.readObject(is);
        } else {
            if (in == null) {
                in = new ByteArrayDataInput();
            }
            in.initialize(blob, version);
            result = DataSerializer.readObject(in);
        }
        BlobHelper.endDeserialization(start, blob.length);
        return result;
    }

    public static Object deserializeOffHeapBlob(StoredObject blob) throws IOException, ClassNotFoundException {
        long start = BlobHelper.startDeserialization();
        PdxInputStream is = new PdxInputStream(blob);
        Object result = DataSerializer.readObject(is);
        BlobHelper.endDeserialization(start, blob.getDataSize());
        return result;
    }

    public static Object deserializeBuffer(ByteArrayDataInput in, int numBytes) throws IOException, ClassNotFoundException {
        long start = BlobHelper.startDeserialization();
        Object result = DataSerializer.readObject(in);
        BlobHelper.endDeserialization(start, numBytes);
        return result;
    }

    private static long startSerialization() {
        long result = 0L;
        DMStats stats = InternalDistributedSystem.getDMStats();
        if (stats != null) {
            result = stats.startSerialization();
        }
        return result;
    }

    private static void endSerialization(long start, int bytes) {
        DMStats stats = InternalDistributedSystem.getDMStats();
        if (stats != null) {
            stats.endSerialization(start, bytes);
        }
    }

    private static long startDeserialization() {
        long result = 0L;
        DMStats stats = InternalDistributedSystem.getDMStats();
        if (stats != null) {
            result = stats.startDeserialization();
        }
        return result;
    }

    private static void endDeserialization(long start, int bytes) {
        DMStats stats = InternalDistributedSystem.getDMStats();
        if (stats != null) {
            stats.endDeserialization(start, bytes);
        }
    }
}

