/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.sequencelog.model;

import com.gemstone.gemfire.internal.sequencelog.model.Graph;
import java.util.SortedMap;

public class Vertex
implements Comparable<Vertex> {
    private final Graph graph;
    private final String name;
    private final long timestamp;
    private final String state;

    public Vertex(Graph graph, String source, String state, long timestamp) {
        this.graph = graph;
        this.name = source;
        this.state = state;
        this.timestamp = timestamp;
    }

    public String getName() {
        return this.name;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getState() {
        return this.state;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Vertex)) {
            return false;
        }
        Vertex other = (Vertex)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.state == null ? other.state != null : !this.state.equals(other.state)) {
            return false;
        }
        return this.timestamp == other.timestamp;
    }

    @Override
    public int compareTo(Vertex o) {
        int difference;
        int n = o.name == null ? (this.name == null ? 0 : -1) : (difference = this.name == null ? 1 : 0);
        if (difference != 0) {
            return difference;
        }
        difference = o.name.compareTo(this.name);
        if (difference != 0) {
            return difference;
        }
        int n2 = o.timestamp > this.timestamp ? 1 : (difference = o.timestamp == this.timestamp ? 0 : -1);
        if (difference != 0) {
            return difference;
        }
        difference = o.state == null ? (this.state == null ? 0 : -1) : (this.state == null ? 1 : o.state.compareTo(this.state));
        return difference;
    }

    public Vertex getNextVertexOnDest() {
        SortedMap<Long, Vertex> map = this.graph.getIndexedVertices().get(this.name);
        SortedMap<Long, Vertex> tailMap = map.tailMap(this.timestamp + 1L);
        if (tailMap.isEmpty()) {
            return null;
        }
        return (Vertex)tailMap.get(tailMap.firstKey());
    }
}

