/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.sequencelog.io;

import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.sequencelog.GraphType;
import com.gemstone.gemfire.internal.sequencelog.io.Filter;
import com.gemstone.gemfire.internal.sequencelog.io.GemfireLogConverter;
import com.gemstone.gemfire.internal.sequencelog.io.InputStreamReader;
import com.gemstone.gemfire.internal.sequencelog.model.GraphSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.regex.Pattern;

public class GraphReader {
    private File[] files;

    public GraphReader(File file) {
        this(new File[]{file});
    }

    public GraphReader(File[] files) {
        this.files = files;
    }

    public GraphSet readGraphs() throws IOException {
        return this.readGraphs(false);
    }

    public GraphSet readGraphs(boolean areGemfireLogs) throws IOException {
        return this.readGraphs(new Filter(){

            @Override
            public boolean accept(GraphType graphType, String name, String edgeName, String source, String dest) {
                return true;
            }

            @Override
            public boolean acceptPattern(GraphType graphType, Pattern pattern, String edgeName, String source, String dest) {
                return true;
            }
        }, areGemfireLogs);
    }

    public GraphSet readGraphs(Filter filter) throws IOException {
        return this.readGraphs(filter, false);
    }

    public GraphSet readGraphs(Filter filter, boolean areGemfireLogs) throws IOException {
        GraphSet graphs = new GraphSet();
        if (areGemfireLogs) {
            HeapDataOutputStream out = new HeapDataOutputStream(Version.CURRENT);
            GemfireLogConverter.convertFiles(out, this.files);
            InputStreamReader reader = new InputStreamReader(out.getInputStream());
            reader.addToGraphs(graphs, filter);
        } else {
            for (File file : this.files) {
                FileInputStream fis = new FileInputStream(file);
                InputStreamReader reader = new InputStreamReader(fis);
                reader.addToGraphs(graphs, filter);
            }
        }
        graphs.readingDone();
        return graphs;
    }
}

