/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.security;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.Instantiator;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.operations.OperationContext;
import com.gemstone.gemfire.cache.operations.PutAllOperationContext;
import com.gemstone.gemfire.cache.operations.PutOperationContext;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.security.ObjectWithAuthz;
import com.gemstone.gemfire.security.AccessControl;
import com.gemstone.gemfire.security.NotAuthorizedException;
import java.security.Principal;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FilterPreAuthorization
implements AccessControl {
    private LogWriterI18n logger = null;

    public static AccessControl create() {
        return new FilterPreAuthorization();
    }

    @Override
    public void init(Principal principal, DistributedMember remoteMember, Cache cache) throws NotAuthorizedException {
        this.logger = cache.getSecurityLoggerI18n();
    }

    @Override
    public boolean authorizeOperation(String regionName, OperationContext context) {
        assert (!context.isPostOperation());
        OperationContext.OperationCode opCode = context.getOperationCode();
        if (opCode.isPut()) {
            byte lastByte;
            int valLength;
            PutOperationContext createContext = (PutOperationContext)context;
            byte[] serializedValue = null;
            Object value = createContext.getValue();
            if (value == null) {
                valLength = 0;
                lastByte = 0;
            } else if (value instanceof byte[]) {
                serializedValue = (byte[])value;
                valLength = serializedValue.length;
                lastByte = serializedValue[valLength - 1];
            } else {
                ObjectWithAuthz authzObj = new ObjectWithAuthz(value, value.hashCode());
                createContext.setValue(authzObj, true);
                return true;
            }
            HeapDataOutputStream hos = new HeapDataOutputStream(valLength + 32, Version.CURRENT);
            try {
                InternalDataSerializer.writeUserDataSerializableHeader(57, hos);
                if (serializedValue != null) {
                    hos.write(serializedValue);
                }
                Integer allowedIndex = lastByte;
                DataSerializer.writeObject(allowedIndex, hos);
            }
            catch (Exception ex) {
                return false;
            }
            createContext.setSerializedValue(hos.toByteArray(), true);
            if (this.logger.fineEnabled()) {
                this.logger.fine("FilterPreAuthorization: added authorization info for key: " + createContext.getKey());
            }
        } else if (opCode.isPutAll()) {
            PutAllOperationContext createContext = (PutAllOperationContext)context;
            Map map = createContext.getMap();
            Set entries = map.entrySet();
            Iterator iterator = entries.iterator();
            Map.Entry mapEntry = null;
            while (iterator.hasNext()) {
                Integer authCode;
                mapEntry = (Map.Entry)iterator.next();
                String currkey = (String)mapEntry.getKey();
                Object value = mapEntry.getValue();
                if (value != null) {
                    String valStr = value.toString();
                    authCode = valStr.charAt(valStr.length() - 1);
                } else {
                    authCode = 0;
                }
                ObjectWithAuthz authzObj = new ObjectWithAuthz(value, authCode);
                mapEntry.setValue(authzObj);
                if (!this.logger.fineEnabled()) continue;
                this.logger.fine("FilterPreAuthorization: putAll: added authorization info for key: " + currkey);
            }
        }
        return true;
    }

    @Override
    public void close() {
    }

    static {
        Instantiator.register(new Instantiator(ObjectWithAuthz.class, 57){

            @Override
            public DataSerializable newInstance() {
                return new ObjectWithAuthz();
            }
        }, false);
    }
}

