/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis.executor.string;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.redis.ByteArrayWrapper;
import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.Command;
import com.gemstone.gemfire.internal.redis.ExecutionHandlerContext;
import com.gemstone.gemfire.internal.redis.executor.string.StringExecutor;
import java.util.List;

public class SetExecutor
extends StringExecutor {
    private final String SUCCESS = "OK";
    private final int VALUE_INDEX = 2;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        Object elem4;
        List<byte[]> commandElems = command.getProcessedCommand();
        Region<ByteArrayWrapper, ByteArrayWrapper> r = context.getRegionProvider().getStringsRegion();
        if (commandElems.size() < 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the SET command is \"SET key value [EX seconds] [PX milliseconds] [NX|XX]\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        this.checkDataType(key, context);
        byte[] value = commandElems.get(2);
        ByteArrayWrapper valueWrapper = new ByteArrayWrapper(value);
        boolean NX = false;
        boolean XX = false;
        long expiration = 0L;
        if (commandElems.size() >= 6) {
            elem4 = Coder.bytesToString(commandElems.get(3));
            String elem5 = Coder.bytesToString(commandElems.get(4));
            String elem6 = Coder.bytesToString(commandElems.get(5));
            if (((String)elem4).equalsIgnoreCase("XX") || elem6.equalsIgnoreCase("XX")) {
                XX = true;
            } else if (((String)elem4).equalsIgnoreCase("NX") || elem6.equalsIgnoreCase("NX")) {
                NX = true;
            }
            if (((String)elem4).equalsIgnoreCase("PX")) {
                expiration = this.getExpirationMillis((String)elem4, elem5);
            } else if (elem5.equalsIgnoreCase("PX")) {
                expiration = this.getExpirationMillis(elem5, elem6);
            } else if (((String)elem4).equalsIgnoreCase("EX")) {
                expiration = this.getExpirationMillis((String)elem4, elem5);
            } else if (elem5.equalsIgnoreCase("EX")) {
                expiration = this.getExpirationMillis(elem5, elem6);
            }
        } else if (commandElems.size() >= 5) {
            elem4 = Coder.bytesToString(commandElems.get(3));
            String expiry = Coder.bytesToString(commandElems.get(4));
            expiration = this.getExpirationMillis((String)elem4, expiry);
        } else if (commandElems.size() >= 4 && ((Object)(elem4 = (Object)commandElems.get(3))).length == 2 && Character.toUpperCase((int)elem4[1]) == 88) {
            if (Character.toUpperCase((int)elem4[0]) == 78) {
                NX = true;
            } else if (Character.toUpperCase((int)elem4[0]) == 88) {
                XX = true;
            }
        }
        boolean keyWasSet = false;
        if (NX) {
            keyWasSet = this.setNX(r, command, key, valueWrapper, context);
        } else if (XX) {
            keyWasSet = this.setXX(r, command, key, valueWrapper, context);
        } else {
            this.checkAndSetDataType(key, context);
            r.put(key, valueWrapper);
            command.setResponse(Coder.getSimpleStringResponse(context.getByteBufAllocator(), "OK"));
            keyWasSet = true;
        }
        if (keyWasSet && expiration > 0L) {
            context.getRegionProvider().setExpiration(key, expiration);
        }
    }

    private boolean setNX(Region<ByteArrayWrapper, ByteArrayWrapper> r, Command command, ByteArrayWrapper key, ByteArrayWrapper valueWrapper, ExecutionHandlerContext context) {
        this.checkAndSetDataType(key, context);
        ByteArrayWrapper oldValue = r.putIfAbsent(key, valueWrapper);
        if (oldValue != null) {
            command.setResponse(Coder.getNilResponse(context.getByteBufAllocator()));
            return false;
        }
        command.setResponse(Coder.getSimpleStringResponse(context.getByteBufAllocator(), "OK"));
        return true;
    }

    private boolean setXX(Region<ByteArrayWrapper, ByteArrayWrapper> r, Command command, ByteArrayWrapper key, ByteArrayWrapper valueWrapper, ExecutionHandlerContext context) {
        if (r.containsKey(key)) {
            this.checkAndSetDataType(key, context);
            r.put(key, valueWrapper);
            command.setResponse(Coder.getSimpleStringResponse(context.getByteBufAllocator(), "OK"));
            return true;
        }
        command.setResponse(Coder.getNilResponse(context.getByteBufAllocator()));
        return false;
    }

    private long getExpirationMillis(String expx, String expirationString) {
        long expiration = 0L;
        try {
            expiration = Long.parseLong(expirationString);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
        if (expx.equalsIgnoreCase("EX")) {
            return expiration * 1000L;
        }
        if (expx.equalsIgnoreCase("PX")) {
            return expiration;
        }
        return 0L;
    }
}

