/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis.executor.string;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.redis.ByteArrayWrapper;
import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.Command;
import com.gemstone.gemfire.internal.redis.ExecutionHandlerContext;
import com.gemstone.gemfire.internal.redis.executor.string.StringExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MGetExecutor
extends StringExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        Region<ByteArrayWrapper, ByteArrayWrapper> r = context.getRegionProvider().getStringsRegion();
        if (commandElems.size() < 2) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the MGET command is \"MGET key [key ...]\""));
            return;
        }
        ArrayList<ByteArrayWrapper> keys = new ArrayList<ByteArrayWrapper>();
        for (int i = 1; i < commandElems.size(); ++i) {
            byte[] keyArray = commandElems.get(i);
            ByteArrayWrapper key = new ByteArrayWrapper(keyArray);
            keys.add(key);
        }
        Map<ByteArrayWrapper, ByteArrayWrapper> results = r.getAll(keys);
        ArrayList<ByteArrayWrapper> values = new ArrayList<ByteArrayWrapper>();
        for (ByteArrayWrapper key : keys) {
            values.add(results.get(key));
        }
        command.setResponse(Coder.getBulkStringArrayResponse(context.getByteBufAllocator(), values));
    }
}

