/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis.executor.string;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.redis.ByteArrayWrapper;
import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.Command;
import com.gemstone.gemfire.internal.redis.ExecutionHandlerContext;
import com.gemstone.gemfire.internal.redis.executor.string.StringExecutor;
import java.util.List;

public class GetSetExecutor
extends StringExecutor {
    private final int VALUE_INDEX = 2;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        Region<ByteArrayWrapper, ByteArrayWrapper> r = context.getRegionProvider().getStringsRegion();
        if (commandElems.size() < 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the GETSET command is \"GETSET key value\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        this.checkAndSetDataType(key, context);
        byte[] newCharValue = commandElems.get(2);
        ByteArrayWrapper newValueWrapper = new ByteArrayWrapper(newCharValue);
        ByteArrayWrapper oldValueWrapper = r.get(key);
        r.put(key, newValueWrapper);
        if (oldValueWrapper == null) {
            command.setResponse(Coder.getNilResponse(context.getByteBufAllocator()));
        } else {
            command.setResponse(Coder.getBulkStringResponse(context.getByteBufAllocator(), oldValueWrapper.toBytes()));
        }
    }
}

