/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis.executor.string;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.redis.ByteArrayWrapper;
import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.Command;
import com.gemstone.gemfire.internal.redis.ExecutionHandlerContext;
import com.gemstone.gemfire.internal.redis.executor.string.StringExecutor;
import java.util.List;

public class GetBitExecutor
extends StringExecutor {
    private final String ERROR_NOT_INT = "The offset provided must be numeric";

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        int offset;
        List<byte[]> commandElems = command.getProcessedCommand();
        Region<ByteArrayWrapper, ByteArrayWrapper> r = context.getRegionProvider().getStringsRegion();
        if (commandElems.size() < 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the GETBIT command is \"GETBIT key offset\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        this.checkAndSetDataType(key, context);
        ByteArrayWrapper wrapper = r.get(key);
        if (wrapper == null) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
            return;
        }
        int bit = 0;
        byte[] bytes = wrapper.toBytes();
        try {
            byte[] offAr = commandElems.get(2);
            offset = Coder.bytesToInt(offAr);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The offset provided must be numeric"));
            return;
        }
        if (offset < 0) {
            offset += bytes.length * 8;
        }
        if (offset < 0 || offset > bytes.length * 8) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
            return;
        }
        int byteIndex = offset / 8;
        offset %= 8;
        if (byteIndex >= bytes.length) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
            return;
        }
        bit = (bytes[byteIndex] & 128 >> offset) >> 7 - offset;
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), bit));
    }
}

