/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis.executor.sortedset;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.redis.ByteArrayWrapper;
import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.Command;
import com.gemstone.gemfire.internal.redis.DoubleWrapper;
import com.gemstone.gemfire.internal.redis.ExecutionHandlerContext;
import com.gemstone.gemfire.internal.redis.RedisDataType;
import com.gemstone.gemfire.internal.redis.executor.sortedset.SortedSetExecutor;
import java.util.List;

public class ZCardExecutor
extends SortedSetExecutor {
    private final int NOT_EXISTS = 0;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 2) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the ZCARD command is \"ZCARD key\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        Region<ByteArrayWrapper, DoubleWrapper> keyRegion = this.getRegion(context, key);
        this.checkDataType(key, RedisDataType.REDIS_SORTEDSET, context);
        if (keyRegion == null) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
        } else {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), keyRegion.size()));
        }
    }
}

