/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis.executor.set;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.redis.ByteArrayWrapper;
import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.Command;
import com.gemstone.gemfire.internal.redis.ExecutionHandlerContext;
import com.gemstone.gemfire.internal.redis.Extendable;
import com.gemstone.gemfire.internal.redis.RedisDataType;
import com.gemstone.gemfire.internal.redis.RegionProvider;
import com.gemstone.gemfire.internal.redis.executor.set.SInterExecutor;
import com.gemstone.gemfire.internal.redis.executor.set.SetExecutor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class SetOpExecutor
extends SetExecutor
implements Extendable {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        int setsStartIndex;
        List<byte[]> commandElems = command.getProcessedCommand();
        int n = setsStartIndex = this.isStorage() ? 2 : 1;
        if (commandElems.size() < setsStartIndex + 1) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), this.getArgsError()));
            return;
        }
        RegionProvider rC = context.getRegionProvider();
        ByteArrayWrapper destination = null;
        if (this.isStorage()) {
            destination = command.getKey();
        }
        ByteArrayWrapper firstSetKey = new ByteArrayWrapper(commandElems.get(setsStartIndex++));
        if (!this.isStorage()) {
            this.checkDataType(firstSetKey, RedisDataType.REDIS_SET, context);
        }
        Region<?, ?> region = rC.getRegion(firstSetKey);
        HashSet<ByteArrayWrapper> firstSet = null;
        if (region != null) {
            firstSet = new HashSet<ByteArrayWrapper>(region.keySet());
        }
        ArrayList<Set<ByteArrayWrapper>> setList = new ArrayList<Set<ByteArrayWrapper>>();
        for (int i = setsStartIndex; i < commandElems.size(); ++i) {
            ByteArrayWrapper key = new ByteArrayWrapper(commandElems.get(i));
            this.checkDataType(key, RedisDataType.REDIS_SET, context);
            region = rC.getRegion(key);
            if (region != null) {
                setList.add(region.keySet());
                continue;
            }
            if (!(this instanceof SInterExecutor)) continue;
            setList.add(null);
        }
        if (setList.isEmpty()) {
            if (this.isStorage()) {
                command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
                context.getRegionProvider().removeKey(destination);
            } else if (firstSet == null) {
                command.setResponse(Coder.getNilResponse(context.getByteBufAllocator()));
            } else {
                command.setResponse(Coder.getBulkStringArrayResponse(context.getByteBufAllocator(), firstSet));
            }
            return;
        }
        Set<ByteArrayWrapper> resultSet = this.setOp(firstSet, setList);
        if (this.isStorage()) {
            Region<?, ?> newRegion = null;
            rC.removeKey(destination);
            if (resultSet != null) {
                HashMap<ByteArrayWrapper, Boolean> map = new HashMap<ByteArrayWrapper, Boolean>();
                for (ByteArrayWrapper entry : resultSet) {
                    map.put(entry, Boolean.TRUE);
                }
                if (!map.isEmpty()) {
                    newRegion = rC.getOrCreateRegion(destination, RedisDataType.REDIS_SET, context);
                    newRegion.putAll(map);
                }
                command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), resultSet.size()));
            } else {
                command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
            }
        } else if (resultSet == null || resultSet.isEmpty()) {
            command.setResponse(Coder.getEmptyArrayResponse(context.getByteBufAllocator()));
        } else {
            command.setResponse(Coder.getBulkStringArrayResponse(context.getByteBufAllocator(), resultSet));
        }
    }

    protected abstract boolean isStorage();

    protected abstract Set<ByteArrayWrapper> setOp(Set<ByteArrayWrapper> var1, List<Set<ByteArrayWrapper>> var2);
}

