/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis.executor.set;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.redis.ByteArrayWrapper;
import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.Command;
import com.gemstone.gemfire.internal.redis.ExecutionHandlerContext;
import com.gemstone.gemfire.internal.redis.RedisDataType;
import com.gemstone.gemfire.internal.redis.executor.set.SetExecutor;
import java.util.List;

public class SMoveExecutor
extends SetExecutor {
    private final int MOVED = 1;
    private final int NOT_MOVED = 0;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 4) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the SMOVE command is \"SMOVE source destination member\""));
            return;
        }
        ByteArrayWrapper source = command.getKey();
        ByteArrayWrapper destination = new ByteArrayWrapper(commandElems.get(2));
        ByteArrayWrapper mem = new ByteArrayWrapper(commandElems.get(3));
        this.checkDataType(source, RedisDataType.REDIS_SET, context);
        this.checkDataType(destination, RedisDataType.REDIS_SET, context);
        Region<?, ?> sourceRegion = context.getRegionProvider().getRegion(source);
        if (sourceRegion == null) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
            return;
        }
        Object oldVal = sourceRegion.get(mem);
        sourceRegion.remove(mem);
        if (oldVal == null) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
            return;
        }
        Region<?, ?> destinationRegion = this.getOrCreateRegion(context, destination, RedisDataType.REDIS_SET);
        destinationRegion.put(mem, true);
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 1));
    }
}

