/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis.executor.set;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.redis.ByteArrayWrapper;
import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.Command;
import com.gemstone.gemfire.internal.redis.ExecutionHandlerContext;
import com.gemstone.gemfire.internal.redis.RedisDataType;
import com.gemstone.gemfire.internal.redis.executor.set.SetExecutor;
import java.util.HashSet;
import java.util.List;

public class SMembersExecutor
extends SetExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 2) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the SMEMBERS command is \"SMEMBERS key\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        this.checkDataType(key, RedisDataType.REDIS_SET, context);
        Region<?, ?> keyRegion = context.getRegionProvider().getRegion(key);
        if (keyRegion == null) {
            command.setResponse(Coder.getEmptyArrayResponse(context.getByteBufAllocator()));
            return;
        }
        HashSet<ByteArrayWrapper> members = new HashSet<ByteArrayWrapper>(keyRegion.keySet());
        command.setResponse(Coder.getBulkStringArrayResponse(context.getByteBufAllocator(), members));
    }
}

