/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis.executor.set;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.redis.ByteArrayWrapper;
import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.Command;
import com.gemstone.gemfire.internal.redis.ExecutionHandlerContext;
import com.gemstone.gemfire.internal.redis.RedisDataType;
import com.gemstone.gemfire.internal.redis.executor.set.SetExecutor;
import java.util.HashMap;
import java.util.List;

public class SAddExecutor
extends SetExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the SADD command is \"SADD key member [member ...]\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        Region<?, ?> keyRegion = context.getRegionProvider().getOrCreateRegion(key, RedisDataType.REDIS_SET, context);
        if (commandElems.size() >= 4) {
            HashMap<ByteArrayWrapper, Boolean> entries = new HashMap<ByteArrayWrapper, Boolean>();
            for (int i = 2; i < commandElems.size(); ++i) {
                entries.put(new ByteArrayWrapper(commandElems.get(i)), true);
            }
            keyRegion.putAll(entries);
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), entries.size()));
        } else {
            Boolean v = keyRegion.put(new ByteArrayWrapper(commandElems.get(2)), true);
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), v == null ? 1 : 0));
        }
    }
}

