/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis.executor.list;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.internal.redis.ByteArrayWrapper;
import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.Command;
import com.gemstone.gemfire.internal.redis.ExecutionHandlerContext;
import com.gemstone.gemfire.internal.redis.RedisDataType;
import com.gemstone.gemfire.internal.redis.executor.ListQuery;
import com.gemstone.gemfire.internal.redis.executor.list.ListExecutor;
import java.util.List;

public class LTrimExecutor
extends ListExecutor {
    private final String ERROR_KEY_NOT_EXISTS = "The key does not exists on this server";
    private final String ERROR_NOT_NUMERIC = "The index provided is not numeric";
    private final String SUCCESS = "OK";

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<Integer> keepList;
        int redisStop;
        int redisStart;
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 4) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the LTRIM command is \"LTRIM key start stop\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        byte[] startArray = commandElems.get(2);
        byte[] stopArray = commandElems.get(3);
        this.checkDataType(key, RedisDataType.REDIS_LIST, context);
        Region<Integer, ByteArrayWrapper> keyRegion = this.getRegion(context, key);
        if (keyRegion == null) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The key does not exists on this server"));
            return;
        }
        int listSize = keyRegion.size() - 2;
        if (listSize == 0) {
            command.setResponse(Coder.getSimpleStringResponse(context.getByteBufAllocator(), "OK"));
            return;
        }
        try {
            redisStart = Coder.bytesToInt(startArray);
            redisStop = Coder.bytesToInt(stopArray);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The index provided is not numeric"));
            return;
        }
        redisStart = this.getBoundedStartIndex(redisStart, listSize);
        redisStop = this.getBoundedEndIndex(redisStop, listSize);
        redisStart = Math.min(redisStart, listSize - 1);
        redisStop = Math.min(redisStop, listSize - 1);
        if (redisStart == 0 && redisStop == listSize - 1) {
            command.setResponse(Coder.getSimpleStringResponse(context.getByteBufAllocator(), "OK"));
            return;
        }
        if (redisStart == 0 && redisStop < redisStart) {
            context.getRegionProvider().removeKey(key, RedisDataType.REDIS_LIST);
            command.setResponse(Coder.getSimpleStringResponse(context.getByteBufAllocator(), "OK"));
            return;
        }
        try {
            keepList = this.getRange(context, key, redisStart, redisStop, keyRegion);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (Integer keyElement : keyRegion.keySet()) {
            if (keepList.contains(keyElement) || !(keyElement instanceof Integer)) continue;
            keyRegion.remove(keyElement);
        }
        keyRegion.put((Integer)((Object)"head"), (ByteArrayWrapper)((Object)keepList.get(0)));
        keyRegion.put((Integer)((Object)"tail"), (ByteArrayWrapper)((Object)keepList.get(keepList.size() - 1)));
        command.setResponse(Coder.getSimpleStringResponse(context.getByteBufAllocator(), "OK"));
    }

    private List<Integer> getRange(ExecutionHandlerContext context, ByteArrayWrapper key, int start, int stop, Region r) throws Exception {
        Object[] params;
        Query query = this.getQuery(key, ListQuery.LTRIM, context);
        SelectResults results = (SelectResults)query.execute(params = new Object[]{stop + 1});
        if (results == null || results.size() <= start) {
            return null;
        }
        return results.asList().subList(start, results.size());
    }
}

