/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis.executor.list;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.internal.redis.ByteArrayWrapper;
import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.Command;
import com.gemstone.gemfire.internal.redis.ExecutionHandlerContext;
import com.gemstone.gemfire.internal.redis.RedisDataType;
import com.gemstone.gemfire.internal.redis.executor.ListQuery;
import com.gemstone.gemfire.internal.redis.executor.list.ListExecutor;
import java.util.List;

public class LRemExecutor
extends ListExecutor {
    private final String ERROR_NOT_NUMERIC = "The count provided is not numeric";
    private final int NOT_EXISTS = 0;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<Struct> removeList;
        int count;
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 4) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the LREM command is \"LREM key count value\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        byte[] countArray = commandElems.get(2);
        byte[] value = commandElems.get(3);
        this.checkDataType(key, RedisDataType.REDIS_LIST, context);
        Region<Integer, ByteArrayWrapper> keyRegion = this.getRegion(context, key);
        if (keyRegion == null) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
            return;
        }
        try {
            count = Coder.bytesToInt(countArray);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The count provided is not numeric"));
            return;
        }
        try {
            removeList = this.getRemoveList(context, key, new ByteArrayWrapper(value), count);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        int numRemoved = 0;
        if (removeList == null) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), numRemoved));
            return;
        }
        for (Struct entry : removeList) {
            Integer removeKey = (Integer)entry.getFieldValues()[0];
            ByteArrayWrapper oldVal = keyRegion.remove(removeKey);
            if (oldVal == null) continue;
            ++numRemoved;
        }
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), numRemoved));
    }

    private List<Struct> getRemoveList(ExecutionHandlerContext context, ByteArrayWrapper key, ByteArrayWrapper value, int count) throws Exception {
        Object[] params;
        Query query;
        if (count > 0) {
            query = this.getQuery(key, ListQuery.LREMG, context);
            params = new Object[]{value, count};
        } else if (count < 0) {
            query = this.getQuery(key, ListQuery.LREML, context);
            params = new Object[]{value, -count};
        } else {
            query = this.getQuery(key, ListQuery.LREME, context);
            params = new Object[]{value};
        }
        SelectResults results = (SelectResults)query.execute(params);
        if (results == null || results.isEmpty()) {
            return null;
        }
        return results.asList();
    }
}

