/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis.executor.list;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.internal.redis.ByteArrayWrapper;
import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.Command;
import com.gemstone.gemfire.internal.redis.ExecutionHandlerContext;
import com.gemstone.gemfire.internal.redis.RedisDataType;
import com.gemstone.gemfire.internal.redis.executor.ListQuery;
import com.gemstone.gemfire.internal.redis.executor.list.ListExecutor;
import java.util.List;

public class LIndexExecutor
extends ListExecutor {
    private final String ERROR_NOT_NUMERIC = "The index provided is not numeric";

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        Struct entry;
        Integer redisIndex;
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the LINDEX command is \"LINDEX key index"));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        byte[] indexArray = commandElems.get(2);
        this.checkDataType(key, RedisDataType.REDIS_LIST, context);
        Region<Integer, ByteArrayWrapper> keyRegion = this.getRegion(context, key);
        if (keyRegion == null) {
            command.setResponse(Coder.getNilResponse(context.getByteBufAllocator()));
            return;
        }
        int listSize = keyRegion.size() - 2;
        try {
            redisIndex = Coder.bytesToInt(indexArray);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The index provided is not numeric"));
            return;
        }
        if (redisIndex < 0) {
            redisIndex = listSize + redisIndex;
        }
        if (redisIndex < 0) {
            command.setResponse(Coder.getNilResponse(context.getByteBufAllocator()));
            return;
        }
        try {
            entry = this.getEntryAtIndex(context, key, redisIndex);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (entry == null) {
            command.setResponse(Coder.getNilResponse(context.getByteBufAllocator()));
            return;
        }
        Object[] entryArray = entry.getFieldValues();
        ByteArrayWrapper valueWrapper = (ByteArrayWrapper)entryArray[1];
        command.setResponse(Coder.getBulkStringResponse(context.getByteBufAllocator(), valueWrapper.toBytes()));
    }

    private Struct getEntryAtIndex(ExecutionHandlerContext context, ByteArrayWrapper key, int index) throws Exception {
        Object[] params;
        Query query = this.getQuery(key, ListQuery.LINDEX, context);
        SelectResults results = (SelectResults)query.execute(params = new Object[]{index + 1});
        if (results == null || results.size() == 0 || results.size() <= index) {
            return null;
        }
        return (Struct)results.asList().get(index);
    }
}

