/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis.executor.hll;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.hll.CardinalityMergeException;
import com.gemstone.gemfire.internal.hll.HyperLogLogPlus;
import com.gemstone.gemfire.internal.hll.ICardinality;
import com.gemstone.gemfire.internal.redis.ByteArrayWrapper;
import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.Command;
import com.gemstone.gemfire.internal.redis.ExecutionHandlerContext;
import com.gemstone.gemfire.internal.redis.RedisDataType;
import com.gemstone.gemfire.internal.redis.executor.hll.HllExecutor;
import java.util.ArrayList;
import java.util.List;

public class PFMergeExecutor
extends HllExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the PFMERGE command is \"PFMERGE destkey sourcekey [sourcekey ...]\""));
            return;
        }
        ByteArrayWrapper destKey = command.getKey();
        this.checkAndSetDataType(destKey, context);
        Region<ByteArrayWrapper, HyperLogLogPlus> keyRegion = context.getRegionProvider().gethLLRegion();
        HyperLogLogPlus mergedHLL = keyRegion.get(destKey);
        if (mergedHLL == null) {
            mergedHLL = new HyperLogLogPlus(DEFAULT_HLL_DENSE);
        }
        ArrayList<HyperLogLogPlus> hlls = new ArrayList<HyperLogLogPlus>();
        for (int i = 2; i < commandElems.size(); ++i) {
            ByteArrayWrapper k = new ByteArrayWrapper(commandElems.get(i));
            this.checkDataType(k, RedisDataType.REDIS_HLL, context);
            HyperLogLogPlus h = keyRegion.get(k);
            if (h == null) continue;
            hlls.add(h);
        }
        if (hlls.isEmpty()) {
            context.getRegionProvider().removeKey(destKey);
            command.setResponse(Coder.getSimpleStringResponse(context.getByteBufAllocator(), "OK"));
            return;
        }
        ICardinality[] estimators = hlls.toArray(new HyperLogLogPlus[hlls.size()]);
        try {
            mergedHLL = (HyperLogLogPlus)mergedHLL.merge(estimators);
        }
        catch (CardinalityMergeException e) {
            throw new RuntimeException(e);
        }
        keyRegion.put(destKey, mergedHLL);
        command.setResponse(Coder.getSimpleStringResponse(context.getByteBufAllocator(), "OK"));
    }
}

