/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis.executor.hll;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.hll.HyperLogLogPlus;
import com.gemstone.gemfire.internal.redis.ByteArrayWrapper;
import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.Command;
import com.gemstone.gemfire.internal.redis.ExecutionHandlerContext;
import com.gemstone.gemfire.internal.redis.executor.hll.HllExecutor;
import java.util.List;

public class PFAddExecutor
extends HllExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 2) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the PFADD command is \"PFADD key element [element ...]\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        this.checkAndSetDataType(key, context);
        Region<ByteArrayWrapper, HyperLogLogPlus> keyRegion = context.getRegionProvider().gethLLRegion();
        HyperLogLogPlus hll = keyRegion.get(key);
        boolean changed = false;
        if (hll == null) {
            hll = new HyperLogLogPlus(DEFAULT_HLL_DENSE);
        }
        for (int i = 2; i < commandElems.size(); ++i) {
            byte[] bytes = commandElems.get(i);
            boolean offerChange = hll.offer(bytes);
            if (!offerChange) continue;
            changed = true;
        }
        keyRegion.put(key, hll);
        if (changed) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 1));
        } else {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
        }
    }
}

