/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis.executor.hash;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.redis.ByteArrayWrapper;
import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.Command;
import com.gemstone.gemfire.internal.redis.ExecutionHandlerContext;
import com.gemstone.gemfire.internal.redis.Extendable;
import com.gemstone.gemfire.internal.redis.RedisDataType;
import com.gemstone.gemfire.internal.redis.executor.hash.HashExecutor;
import java.util.List;

public class HSetExecutor
extends HashExecutor
implements Extendable {
    private final int EXISTING_FIELD = 0;
    private final int NEW_FIELD = 1;
    private final int VALUE_INDEX = 3;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 4) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), this.getArgsError()));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        Region<ByteArrayWrapper, ByteArrayWrapper> keyRegion = this.getOrCreateRegion(context, key, RedisDataType.REDIS_HASH);
        byte[] byteField = commandElems.get(2);
        ByteArrayWrapper field = new ByteArrayWrapper(byteField);
        byte[] value = commandElems.get(3);
        ByteArrayWrapper oldValue = this.onlySetOnAbsent() ? keyRegion.putIfAbsent(field, new ByteArrayWrapper(value)) : keyRegion.put(field, new ByteArrayWrapper(value));
        if (oldValue == null) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 1));
        } else {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
        }
    }

    protected boolean onlySetOnAbsent() {
        return false;
    }

    @Override
    public String getArgsError() {
        return "The wrong number of arguments or syntax was provided, the format for the HSET command is \"HSET key field value\"";
    }
}

