/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis.executor;

import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.Command;
import com.gemstone.gemfire.internal.redis.ExecutionHandlerContext;
import com.gemstone.gemfire.internal.redis.executor.AbstractExecutor;
import io.netty.buffer.ByteBuf;

public class TimeExecutor
extends AbstractExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        long timeStamp = System.currentTimeMillis();
        long seconds = timeStamp / 1000L;
        long microSeconds = (timeStamp - seconds * 1000L) * 1000L;
        byte[] secAr = Coder.longToBytes(seconds);
        byte[] micAr = Coder.longToBytes(microSeconds);
        ByteBuf response = context.getByteBufAllocator().buffer(50);
        response.writeByte(42);
        response.writeByte(50);
        response.writeBytes(Coder.CRLFar);
        response.writeByte(36);
        response.writeBytes(Coder.intToBytes(secAr.length));
        response.writeBytes(Coder.CRLFar);
        response.writeBytes(secAr);
        response.writeBytes(Coder.CRLFar);
        response.writeByte(36);
        response.writeBytes(Coder.intToBytes(micAr.length));
        response.writeBytes(Coder.CRLFar);
        response.writeBytes(micAr);
        response.writeBytes(Coder.CRLFar);
        command.setResponse(response);
    }
}

