/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis.executor;

import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.Command;
import com.gemstone.gemfire.internal.redis.ExecutionHandlerContext;
import com.gemstone.gemfire.internal.redis.executor.AbstractScanExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ScanExecutor
extends AbstractScanExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        String tmp;
        byte[] bytes;
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 2) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the SCAN command is \"SCAN cursor [MATCH pattern] [COUNT count]\""));
            return;
        }
        String cursorString = command.getStringKey();
        int cursor = 0;
        Pattern matchPattern = null;
        String globMatchString = null;
        int count = 10;
        try {
            cursor = Integer.parseInt(cursorString);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Invalid cursor"));
            return;
        }
        if (cursor < 0) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Invalid cursor"));
            return;
        }
        if (commandElems.size() > 3) {
            try {
                bytes = commandElems.get(2);
                tmp = Coder.bytesToString(bytes);
                if (tmp.equalsIgnoreCase("MATCH")) {
                    bytes = commandElems.get(3);
                    globMatchString = Coder.bytesToString(bytes);
                } else if (tmp.equalsIgnoreCase("COUNT")) {
                    bytes = commandElems.get(3);
                    count = Coder.bytesToInt(bytes);
                }
            }
            catch (NumberFormatException e) {
                command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Count must be numeric and positive"));
                return;
            }
        }
        if (commandElems.size() > 5) {
            try {
                bytes = commandElems.get(4);
                tmp = Coder.bytesToString(bytes);
                if (tmp.equalsIgnoreCase("COUNT")) {
                    bytes = commandElems.get(5);
                    count = Coder.bytesToInt(bytes);
                }
            }
            catch (NumberFormatException e) {
                command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Count must be numeric and positive"));
                return;
            }
        }
        if (count < 0) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Count must be numeric and positive"));
            return;
        }
        try {
            matchPattern = this.convertGlobToRegex(globMatchString);
        }
        catch (PatternSyntaxException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Incorrect syntax for given glob regex"));
            return;
        }
        List<?> returnList = this.getIteration(context.getRegionProvider().metaKeySet(), matchPattern, count, cursor);
        command.setResponse(Coder.getScanResponse(context.getByteBufAllocator(), returnList));
    }

    @Override
    protected List<?> getIteration(Collection<?> list, Pattern matchPattern, int count, int cursor) {
        ArrayList<String> returnList = new ArrayList<String>();
        int size = list.size();
        int beforeCursor = 0;
        int numElements = 0;
        int i = -1;
        for (String key : list) {
            if (key.equals("__ReDiS_MeTa_DaTa") || key.equals("__StRiNgS") || key.equals("__HlL")) continue;
            ++i;
            if (beforeCursor < cursor) {
                ++beforeCursor;
                continue;
            }
            if (numElements >= count) break;
            if (matchPattern != null) {
                if (!matchPattern.matcher(key).matches()) continue;
                returnList.add(key);
                ++numElements;
                continue;
            }
            returnList.add(key);
            ++numElements;
        }
        if (i == size - 4) {
            returnList.add(0, String.valueOf(0));
        } else {
            returnList.add(0, String.valueOf(i));
        }
        return returnList;
    }
}

