/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis.executor;

import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.Command;
import com.gemstone.gemfire.internal.redis.ExecutionHandlerContext;
import com.gemstone.gemfire.internal.redis.executor.AbstractExecutor;
import com.gemstone.gemfire.internal.redis.org.apache.hadoop.fs.GlobPattern;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class KeysExecutor
extends AbstractExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        Pattern pattern;
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 2) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the KEYS command is \"KEYS pattern\""));
            return;
        }
        String glob = Coder.bytesToString(commandElems.get(1));
        Set<String> allKeys = context.getRegionProvider().metaKeySet();
        ArrayList<String> matchingKeys = new ArrayList<String>();
        try {
            pattern = GlobPattern.compile(glob);
        }
        catch (PatternSyntaxException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Incorrect syntax for given glob regex"));
            return;
        }
        for (String key : allKeys) {
            if (key.equals("__ReDiS_MeTa_DaTa") || key.equals("__StRiNgS") || key.equals("__HlL") || !pattern.matcher(key).matches()) continue;
            matchingKeys.add(key);
        }
        if (matchingKeys.isEmpty()) {
            command.setResponse(Coder.getEmptyArrayResponse(context.getByteBufAllocator()));
        } else {
            command.setResponse(Coder.getBulkStringArrayResponse(context.getByteBufAllocator(), matchingKeys));
        }
    }
}

