/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis.executor;

import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.Command;
import com.gemstone.gemfire.internal.redis.ExecutionHandlerContext;
import com.gemstone.gemfire.internal.redis.executor.AbstractExecutor;
import java.util.List;

public class EchoExecutor
extends AbstractExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 2) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the ECHO command is \"ECHO message\""));
            return;
        }
        byte[] echoMessage = commandElems.get(1);
        command.setResponse(Coder.getBulkStringResponse(context.getByteBufAllocator(), echoMessage));
    }
}

