/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis.executor;

import com.gemstone.gemfire.cache.UnsupportedOperationInTransactionException;
import com.gemstone.gemfire.internal.redis.ByteArrayWrapper;
import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.Command;
import com.gemstone.gemfire.internal.redis.ExecutionHandlerContext;
import com.gemstone.gemfire.internal.redis.RedisDataType;
import com.gemstone.gemfire.internal.redis.executor.AbstractExecutor;
import java.util.List;

public class DelExecutor
extends AbstractExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        if (context.hasTransaction()) {
            throw new UnsupportedOperationInTransactionException();
        }
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 2) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the DEL command is \"DEL key [key ...]\""));
            return;
        }
        int numRemoved = 0;
        for (int i = 1; i < commandElems.size(); ++i) {
            RedisDataType type;
            byte[] byteKey = commandElems.get(i);
            ByteArrayWrapper key = new ByteArrayWrapper(byteKey);
            if (!this.removeEntry(key, type = context.getRegionProvider().getRedisDataType(key), context)) continue;
            ++numRemoved;
        }
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), numRemoved));
    }
}

