/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis.executor;

import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.Command;
import com.gemstone.gemfire.internal.redis.ExecutionHandlerContext;
import com.gemstone.gemfire.internal.redis.Executor;
import java.util.Arrays;
import java.util.List;

public class AuthExecutor
implements Executor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 2) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the AUTH command is \"AUTH password\""));
            return;
        }
        byte[] pwd = context.getAuthPwd();
        if (pwd == null) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Attempting to authenticate when no password has been set"));
            return;
        }
        boolean correct = Arrays.equals(commandElems.get(1), pwd);
        if (correct) {
            context.setAuthenticationVerified();
            command.setResponse(Coder.getSimpleStringResponse(context.getByteBufAllocator(), "OK"));
        } else {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Attemping to authenticate with an invalid password"));
        }
    }
}

