/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.TransactionException;
import com.gemstone.gemfire.cache.TransactionId;
import com.gemstone.gemfire.cache.UnsupportedOperationInTransactionException;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.RegionNotFoundException;
import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.Command;
import com.gemstone.gemfire.internal.redis.Executor;
import com.gemstone.gemfire.internal.redis.RedisCommandParserException;
import com.gemstone.gemfire.internal.redis.RedisCommandType;
import com.gemstone.gemfire.internal.redis.RedisDataTypeMismatchException;
import com.gemstone.gemfire.internal.redis.RegionCreationException;
import com.gemstone.gemfire.internal.redis.RegionProvider;
import com.gemstone.gemfire.internal.redis.executor.transactions.TransactionExecutor;
import com.gemstone.gemfire.redis.GemFireRedisServer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.DecoderException;
import io.netty.util.concurrent.EventExecutor;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class ExecutionHandlerContext
extends ChannelInboundHandlerAdapter {
    private static final int WAIT_REGION_DSTRYD_MILLIS = 100;
    private static final int MAXIMUM_NUM_RETRIES = 600;
    private final Cache cache;
    private final GemFireRedisServer server;
    private final LogWriter logger;
    private final Channel channel;
    private final AtomicBoolean needChannelFlush;
    private final Runnable flusher;
    private final EventExecutor lastExecutor;
    private final ByteBufAllocator byteBufAllocator;
    private TransactionId transactionID;
    private Queue<Command> transactionQueue;
    private final RegionProvider regionProvider;
    private final byte[] authPwd;
    private boolean isAuthenticated;

    public ExecutionHandlerContext(Channel ch, Cache cache, RegionProvider regionProvider, GemFireRedisServer server, byte[] pwd) {
        if (ch == null || cache == null || regionProvider == null || server == null) {
            throw new IllegalArgumentException("Only the authentication password may be null");
        }
        this.cache = cache;
        this.server = server;
        this.logger = cache.getLogger();
        this.channel = ch;
        this.needChannelFlush = new AtomicBoolean(false);
        this.flusher = new Runnable(){

            @Override
            public void run() {
                ExecutionHandlerContext.this.flushChannel();
            }
        };
        this.lastExecutor = this.channel.pipeline().lastContext().executor();
        this.byteBufAllocator = this.channel.alloc();
        this.transactionID = null;
        this.transactionQueue = null;
        this.regionProvider = regionProvider;
        this.authPwd = pwd;
        this.isAuthenticated = pwd == null;
    }

    private void flushChannel() {
        while (this.needChannelFlush.getAndSet(false)) {
            this.channel.flush();
        }
    }

    private void writeToChannel(ByteBuf message) {
        this.channel.write((Object)message, this.channel.voidPromise());
        if (!this.needChannelFlush.getAndSet(true)) {
            this.lastExecutor.execute(this.flusher);
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        Command command = (Command)msg;
        this.executeCommand(ctx, command);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (cause instanceof IOException) {
            this.channelInactive(ctx);
            return;
        }
        ByteBuf response = this.getExceptionResponse(ctx, cause);
        this.writeToChannel(response);
    }

    private ByteBuf getExceptionResponse(ChannelHandlerContext ctx, Throwable cause) {
        ByteBuf response;
        if (cause instanceof RedisDataTypeMismatchException) {
            response = Coder.getWrongTypeResponse(this.byteBufAllocator, cause.getMessage());
        } else if (cause instanceof DecoderException && cause.getCause() instanceof RedisCommandParserException) {
            response = Coder.getErrorResponse(this.byteBufAllocator, "The command recieved by GemFireRedisServer was improperly formatted");
        } else if (cause instanceof RegionCreationException) {
            this.logger.error(cause);
            response = Coder.getErrorResponse(this.byteBufAllocator, "This key could not be created. Gemfire does not allow certain characters to used in keys");
        } else if (cause instanceof InterruptedException || cause instanceof CacheClosedException) {
            response = Coder.getErrorResponse(this.byteBufAllocator, "The server is shutting down");
        } else if (cause instanceof IllegalStateException) {
            response = Coder.getErrorResponse(this.byteBufAllocator, cause.getMessage());
        } else {
            if (this.logger.errorEnabled()) {
                this.logger.error("GemFireRedisServer-Unexpected error handler for " + ctx.channel(), cause);
            }
            response = Coder.getErrorResponse(this.byteBufAllocator, "The server had an internal error please try again");
        }
        return response;
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.logger.fineEnabled()) {
            this.logger.fine("GemFireRedisServer-Connection closing with " + ctx.channel().remoteAddress());
        }
        ctx.channel().close();
        ctx.close();
    }

    private void executeCommand(ChannelHandlerContext ctx, Command command) throws Exception {
        RedisCommandType type = command.getCommandType();
        Executor exec = type.getExecutor();
        if (this.isAuthenticated) {
            if (type == RedisCommandType.SHUTDOWN) {
                this.server.shutdown();
                return;
            }
            if (this.hasTransaction() && !(exec instanceof TransactionExecutor)) {
                this.executeWithTransaction(ctx, exec, command);
            } else {
                this.executeWithoutTransaction(exec, command);
            }
            if (this.hasTransaction() && command.getCommandType() != RedisCommandType.MULTI) {
                this.writeToChannel(Coder.getSimpleStringResponse(this.byteBufAllocator, "QUEUED"));
            } else {
                ByteBuf response = command.getResponse();
                this.writeToChannel(response);
            }
        } else if (type == RedisCommandType.QUIT) {
            exec.executeCommand(command, this);
            ByteBuf response = command.getResponse();
            this.writeToChannel(response);
            this.channelInactive(ctx);
        } else if (type == RedisCommandType.AUTH) {
            exec.executeCommand(command, this);
            ByteBuf response = command.getResponse();
            this.writeToChannel(response);
        } else {
            ByteBuf r = Coder.getNoAuthResponse(this.byteBufAllocator, "Must authenticate before sending any requests");
            this.writeToChannel(r);
        }
    }

    private void executeWithoutTransaction(Executor exec, Command command) throws Exception {
        Exception cause = null;
        for (int i = 0; i < 600; ++i) {
            try {
                exec.executeCommand(command, this);
                return;
            }
            catch (Exception e) {
                cause = e;
                if (!(e instanceof RegionDestroyedException) && !(e instanceof RegionNotFoundException) && !(e.getCause() instanceof QueryInvocationTargetException)) continue;
                Thread.sleep(100L);
                continue;
            }
        }
        throw cause;
    }

    private void executeWithTransaction(ChannelHandlerContext ctx, Executor exec, Command command) throws Exception {
        CacheTransactionManager txm = this.cache.getCacheTransactionManager();
        TransactionId transactionId = this.getTransactionID();
        txm.resume(transactionId);
        try {
            exec.executeCommand(command, this);
        }
        catch (UnsupportedOperationInTransactionException e) {
            command.setResponse(Coder.getErrorResponse(this.byteBufAllocator, "This command is not supported within a transaction"));
        }
        catch (TransactionException e) {
            command.setResponse(Coder.getErrorResponse(this.byteBufAllocator, "This transcation cannot be initiated, make sure the command is executed against a replicate region or your data is collocated. If you are using persistent regions, make sure transactions are enabled"));
        }
        catch (Exception e) {
            ByteBuf response = this.getExceptionResponse(ctx, e);
            command.setResponse(response);
        }
        this.getTransactionQueue().add(command);
        transactionId = txm.suspend();
        this.setTransactionID(transactionId);
    }

    public TransactionId getTransactionID() {
        return this.transactionID;
    }

    public boolean hasTransaction() {
        return this.transactionID != null;
    }

    public void setTransactionID(TransactionId id) {
        this.transactionID = id;
    }

    public void clearTransaction() {
        this.transactionID = null;
        if (this.transactionQueue != null) {
            for (Command c : this.transactionQueue) {
                ByteBuf r = c.getResponse();
                if (r == null) continue;
                r.release();
            }
            this.transactionQueue.clear();
        }
    }

    public Queue<Command> getTransactionQueue() {
        if (this.transactionQueue == null) {
            this.transactionQueue = new ConcurrentLinkedQueue<Command>();
        }
        return this.transactionQueue;
    }

    public ByteBufAllocator getByteBufAllocator() {
        return this.byteBufAllocator;
    }

    public RegionProvider getRegionProvider() {
        return this.regionProvider;
    }

    public CacheTransactionManager getCacheTransactionManager() {
        return this.cache.getCacheTransactionManager();
    }

    public LogWriter getLogger() {
        return this.cache.getLogger();
    }

    public byte[] getAuthPwd() {
        return this.authPwd;
    }

    public boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    public void setAuthenticationVerified() {
        this.isAuthenticated = true;
    }
}

