/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.process;

import com.gemstone.gemfire.internal.process.FileProcessController;
import com.gemstone.gemfire.internal.process.MBeanProcessController;
import com.gemstone.gemfire.internal.process.PidFile;
import com.gemstone.gemfire.internal.process.ProcessController;
import com.gemstone.gemfire.internal.process.ProcessControllerParameters;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class ProcessControllerFactory {
    public static final String PROPERTY_DISABLE_ATTACH_API = "gemfire.test.ProcessControllerFactory.DisableAttachApi";
    private final boolean disableAttachApi = Boolean.getBoolean("gemfire.test.ProcessControllerFactory.DisableAttachApi");

    public ProcessController createProcessController(ProcessControllerParameters arguments, int pid) {
        if (arguments == null) {
            throw new NullPointerException("ProcessControllerParameters must not be null");
        }
        if (pid < 1) {
            throw new IllegalArgumentException("Invalid pid '" + pid + "' specified");
        }
        try {
            if (this.isAttachAPIFound()) {
                return new MBeanProcessController(arguments, pid);
            }
            return new FileProcessController(arguments, pid);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            return null;
        }
    }

    public ProcessController createProcessController(ProcessControllerParameters arguments, File pidFile, long timeout, TimeUnit unit) throws IOException, InterruptedException, TimeoutException {
        if (arguments == null) {
            throw new NullPointerException("ProcessControllerParameters must not be null");
        }
        if (pidFile == null) {
            throw new NullPointerException("Pid file must not be null");
        }
        return this.createProcessController(arguments, new PidFile(pidFile).readPid(timeout, unit));
    }

    public ProcessController createProcessController(ProcessControllerParameters arguments, File directory, String pidFilename, long timeout, TimeUnit unit) throws IOException, InterruptedException, TimeoutException {
        if (arguments == null) {
            throw new NullPointerException("ProcessControllerParameters must not be null");
        }
        if (directory == null) {
            throw new NullPointerException("Directory must not be null");
        }
        if (pidFilename == null) {
            throw new NullPointerException("Pid file name must not be null");
        }
        return this.createProcessController(arguments, new PidFile(directory, pidFilename).readPid(timeout, unit));
    }

    public boolean isAttachAPIFound() {
        if (this.disableAttachApi) {
            return false;
        }
        boolean found = false;
        try {
            Class<?> virtualMachineClass = Class.forName("com.sun.tools.attach.VirtualMachine");
            found = virtualMachineClass != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return found;
    }
}

