/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.process;

import com.gemstone.gemfire.distributed.AbstractLauncher;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.process.ControlFileWatchdog;
import com.gemstone.gemfire.internal.process.ControlNotificationHandler;
import com.gemstone.gemfire.internal.process.FileAlreadyExistsException;
import com.gemstone.gemfire.internal.process.LocalProcessLauncher;
import com.gemstone.gemfire.internal.process.PidUnavailableException;
import com.gemstone.gemfire.internal.process.ProcessType;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.logging.log4j.Logger;

public final class ControllableProcess {
    private static final Logger logger = LogService.getLogger();
    private final File workingDir;
    private final File pidFile;
    private final LocalProcessLauncher launcher;
    private final ControlFileWatchdog stopRequestFileWatchdog;
    private final ControlFileWatchdog statusRequestFileWatchdog;

    public ControllableProcess(final ControlNotificationHandler handler, final File workingDir, final ProcessType processType, boolean force) throws FileAlreadyExistsException, IOException, PidUnavailableException {
        this.workingDir = workingDir;
        this.pidFile = new File(this.workingDir, processType.getPidFileName());
        ControllableProcess.deleteFiles(this.workingDir, processType);
        this.launcher = new LocalProcessLauncher(this.pidFile, force);
        ControlFileWatchdog.ControlRequestHandler stopHandler = new ControlFileWatchdog.ControlRequestHandler(){

            @Override
            public void handleRequest() {
                handler.handleStop();
            }
        };
        ControlFileWatchdog.ControlRequestHandler statusHandler = new ControlFileWatchdog.ControlRequestHandler(){

            @Override
            public void handleRequest() throws IOException {
                AbstractLauncher.ServiceState<?> state = handler.handleStatus();
                File statusFile = new File(workingDir, processType.getStatusFileName());
                if (statusFile.exists()) {
                    statusFile.delete();
                }
                boolean created = statusFile.createNewFile();
                assert (created);
                FileWriter writer = new FileWriter(statusFile);
                writer.write(state.toJson());
                writer.flush();
                writer.close();
            }
        };
        this.stopRequestFileWatchdog = new ControlFileWatchdog(workingDir, processType.getStopRequestFileName(), stopHandler, false);
        this.stopRequestFileWatchdog.start();
        this.statusRequestFileWatchdog = new ControlFileWatchdog(workingDir, processType.getStatusRequestFileName(), statusHandler, false);
        this.statusRequestFileWatchdog.start();
    }

    public int getPid() {
        return this.launcher.getPid();
    }

    public File getPidFile() {
        return this.launcher.getPidFile();
    }

    public void stop() {
        try {
            this.statusRequestFileWatchdog.stop();
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted while stopping status handler for controllable process.", (Throwable)e);
        }
        finally {
            try {
                this.stopRequestFileWatchdog.stop();
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted while stopping stop handler for controllable process.", (Throwable)e);
            }
            this.launcher.close();
        }
    }

    protected File getWorkingDir() {
        return this.workingDir;
    }

    private static void deleteFiles(File workingDir, ProcessType processType) {
        ControllableProcess.deleteFile(workingDir, processType.getStatusRequestFileName());
        ControllableProcess.deleteFile(workingDir, processType.getStatusFileName());
        ControllableProcess.deleteFile(workingDir, processType.getStopRequestFileName());
    }

    private static void deleteFile(File workingDir, String fileName) {
        File file = new File(workingDir, fileName);
        if (file.exists()) {
            file.delete();
        }
    }
}

