/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.offheap;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public class RefCountChangeInfo
extends Throwable {
    private final String threadName = Thread.currentThread().getName();
    private final int rc;
    private final Object owner;
    private int useCount;
    private Object stackTraceString;

    public RefCountChangeInfo(boolean decRefCount, int rc, Object owner) {
        super(decRefCount ? "FREE" : "USED");
        this.rc = rc;
        this.owner = owner;
    }

    public Object getOwner() {
        return this.owner;
    }

    public int getUseCount() {
        return this.useCount;
    }

    public int incUseCount() {
        ++this.useCount;
        return this.useCount;
    }

    public int decUseCount() {
        --this.useCount;
        return this.useCount;
    }

    @Override
    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(65536);
        PrintStream ps = new PrintStream(baos);
        ps.print(this.getMessage());
        ps.print(" rc=");
        ps.print(this.rc);
        if (this.useCount > 0) {
            ps.print(" useCount=");
            ps.print(this.useCount);
        }
        ps.print(" by ");
        ps.print(this.threadName);
        if (this.owner != null) {
            ps.print(" owner=");
            ps.print(this.owner.getClass().getName());
            ps.print("@");
            ps.print(System.identityHashCode(this.owner));
        }
        ps.println(": ");
        this.cleanStackTrace(ps);
        ps.flush();
        return baos.toString();
    }

    public boolean isSameCaller(RefCountChangeInfo other) {
        if (!this.getMessage().equals(other.getMessage())) {
            return false;
        }
        Object trace = this.getStackTraceString();
        Object traceOther = other.getStackTraceString();
        if (trace.hashCode() != traceOther.hashCode()) {
            return false;
        }
        return trace.equals(traceOther);
    }

    Object getStackTraceString() {
        Object result = this.stackTraceString;
        if (result == null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(65536);
            PrintStream spr = new PrintStream(baos);
            this.cleanStackTrace(spr);
            this.stackTraceString = result = baos.toString();
        }
        return result;
    }

    void setStackTraceString(Object sts) {
        this.stackTraceString = sts;
    }

    private void cleanStackTrace(PrintStream ps) {
        int i;
        StackTraceElement[] trace = this.getStackTrace();
        int skip = 0;
        for (i = 0; i < trace.length; ++i) {
            if (trace[i].toString().contains("com.gemstone.gemfire.internal.offheap")) continue;
            skip = i;
            break;
        }
        for (i = skip; i < trace.length; ++i) {
            ps.println("\tat " + trace[i]);
        }
    }
}

