/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.offheap;

import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.internal.offheap.ReferenceCountHelper;
import com.gemstone.gemfire.internal.offheap.StoredObject;

public class OffHeapHelper {
    private OffHeapHelper() {
    }

    public static Object getHeapForm(Object o) {
        if (o instanceof StoredObject) {
            return ((StoredObject)o).getValueAsDeserializedHeapObject();
        }
        return o;
    }

    public static Object copyAndReleaseIfNeeded(Object v) {
        if (v instanceof StoredObject) {
            StoredObject ohv = (StoredObject)v;
            try {
                if (ohv.isSerialized()) {
                    CachedDeserializable cachedDeserializable = CachedDeserializableFactory.create(ohv.getSerializedValue());
                    return cachedDeserializable;
                }
                Object object = ohv.getDeserializedForReading();
                return object;
            }
            finally {
                OffHeapHelper.release(ohv);
            }
        }
        return v;
    }

    public static Object copyIfNeeded(Object v) {
        if (v instanceof StoredObject) {
            StoredObject ohv = (StoredObject)v;
            v = ohv.isSerialized() ? CachedDeserializableFactory.create(ohv.getSerializedValue()) : ohv.getDeserializedForReading();
        }
        return v;
    }

    public static boolean release(Object o) {
        if (o instanceof StoredObject) {
            ((StoredObject)o).release();
            return true;
        }
        return false;
    }

    public static boolean releaseWithNoTracking(Object o) {
        if (o instanceof StoredObject) {
            StoredObject so = (StoredObject)o;
            if (!so.hasRefCount()) {
                so.release();
                return true;
            }
            ReferenceCountHelper.skipRefCountTracking();
            so.release();
            ReferenceCountHelper.unskipRefCountTracking();
            return true;
        }
        return false;
    }

    public static boolean releaseAndTrackOwner(Object o, Object owner) {
        if (o instanceof StoredObject) {
            StoredObject so = (StoredObject)o;
            if (!so.hasRefCount()) {
                so.release();
                return true;
            }
            ReferenceCountHelper.setReferenceCountOwner(owner);
            so.release();
            ReferenceCountHelper.setReferenceCountOwner(null);
            return true;
        }
        return false;
    }
}

