/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.offheap;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.lang.StringUtils;
import com.gemstone.gemfire.internal.offheap.StoredObject;
import java.io.DataOutput;
import java.io.IOException;

public abstract class AbstractStoredObject
implements StoredObject {
    @Override
    public Object getValueAsDeserializedHeapObject() {
        return this.getDeserializedValue(null, null);
    }

    @Override
    public byte[] getValueAsHeapByteArray() {
        if (this.isSerialized()) {
            return this.getSerializedValue();
        }
        return (byte[])this.getDeserializedForReading();
    }

    @Override
    public String getStringForm() {
        try {
            return StringUtils.forceToString(this.getDeserializedForReading());
        }
        catch (RuntimeException ex) {
            return "Could not convert object to string because " + ex;
        }
    }

    @Override
    public Object getDeserializedForReading() {
        return this.getDeserializedValue(null, null);
    }

    @Override
    public Object getDeserializedWritableCopy(Region r, RegionEntry re) {
        return this.getDeserializedValue(null, null);
    }

    @Override
    public Object getValue() {
        if (this.isSerialized()) {
            return this.getSerializedValue();
        }
        throw new IllegalStateException("Can not call getValue on StoredObject that is not serialized");
    }

    @Override
    public void writeValueAsByteArray(DataOutput out) throws IOException {
        DataSerializer.writeByteArray(this.getSerializedValue(), out);
    }

    @Override
    public void sendTo(DataOutput out) throws IOException {
        if (this.isSerialized()) {
            out.write(this.getSerializedValue());
        } else {
            byte[] objToSend = (byte[])this.getDeserializedForReading();
            DataSerializer.writeObject(objToSend, out);
        }
    }

    @Override
    public void sendAsByteArray(DataOutput out) throws IOException {
        byte[] bytes = this.isSerialized() ? this.getSerializedValue() : (byte[])this.getDeserializedForReading();
        DataSerializer.writeByteArray(bytes, out);
    }

    @Override
    public void sendAsCachedDeserializable(DataOutput out) throws IOException {
        if (!this.isSerialized()) {
            throw new IllegalStateException("sendAsCachedDeserializable can only be called on serialized StoredObjects");
        }
        InternalDataSerializer.writeDSFIDHeader(-64, out);
        this.sendAsByteArray(out);
    }

    @Override
    public boolean usesHeapForStorage() {
        return false;
    }

    @Override
    public boolean isSerializedPdxInstance() {
        if (!this.isSerialized()) {
            return false;
        }
        byte dsCode = this.readDataByte(0);
        return dsCode == 93 || dsCode == 94 || dsCode == 101;
    }

    @Override
    public StoredObject getStoredObjectWithoutHeapForm() {
        return this;
    }
}

