/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.modules.util;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.Instantiator;
import com.gemstone.gemfire.cache.CustomExpiry;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class RegionConfiguration
implements DataSerializable {
    private String regionName;
    private String regionAttributesId;
    public static final int DEFAULT_MAX_INACTIVE_INTERVAL = -1;
    private int maxInactiveInterval = -1;
    private CustomExpiry customExpiry;
    private boolean enableGatewayDeltaReplication = false;
    private boolean enableGatewayReplication = false;
    private boolean enableDebugListener = false;
    private String cacheWriterName;

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void setRegionAttributesId(String regionAttributesId) {
        this.regionAttributesId = regionAttributesId;
    }

    public String getRegionAttributesId() {
        return this.regionAttributesId;
    }

    public void setMaxInactiveInterval(int maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void setCustomExpiry(CustomExpiry customExpiry) {
        this.customExpiry = customExpiry;
    }

    public CustomExpiry getCustomExpiry() {
        return this.customExpiry;
    }

    public void setEnableGatewayDeltaReplication(boolean enableGatewayDeltaReplication) {
        this.enableGatewayDeltaReplication = enableGatewayDeltaReplication;
    }

    public boolean getEnableGatewayDeltaReplication() {
        return this.enableGatewayDeltaReplication;
    }

    public void setEnableGatewayReplication(boolean enableGatewayReplication) {
        this.enableGatewayReplication = enableGatewayReplication;
    }

    public boolean getEnableGatewayReplication() {
        return this.enableGatewayReplication;
    }

    public void setEnableDebugListener(boolean enableDebugListener) {
        this.enableDebugListener = enableDebugListener;
    }

    public boolean getEnableDebugListener() {
        return this.enableDebugListener;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString(this.regionName, out);
        DataSerializer.writeString(this.regionAttributesId, out);
        DataSerializer.writePrimitiveInt(this.maxInactiveInterval, out);
        DataSerializer.writeObject(this.customExpiry, out);
        DataSerializer.writeBoolean(this.enableGatewayDeltaReplication, out);
        DataSerializer.writeBoolean(this.enableGatewayReplication, out);
        DataSerializer.writeBoolean(this.enableDebugListener, out);
        DataSerializer.writeString(this.cacheWriterName, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.regionName = DataSerializer.readString(in);
        this.regionAttributesId = DataSerializer.readString(in);
        this.maxInactiveInterval = DataSerializer.readPrimitiveInt(in);
        this.customExpiry = (CustomExpiry)DataSerializer.readObject(in);
        this.enableGatewayDeltaReplication = DataSerializer.readBoolean(in);
        this.enableGatewayReplication = DataSerializer.readBoolean(in);
        this.enableDebugListener = DataSerializer.readBoolean(in);
        this.cacheWriterName = DataSerializer.readString(in);
    }

    public static void registerInstantiator(int id) {
        Instantiator.register(new Instantiator(RegionConfiguration.class, id){

            @Override
            public DataSerializable newInstance() {
                return new RegionConfiguration();
            }
        });
    }

    public String toString() {
        return "RegionConfiguration[" + "regionName=" + this.regionName + "; regionAttributesId=" + this.regionAttributesId + "; maxInactiveInterval=" + this.maxInactiveInterval + "; enableGatewayDeltaReplication=" + this.enableGatewayDeltaReplication + "; enableGatewayReplication=" + this.enableGatewayReplication + "; enableDebugListener=" + this.enableDebugListener + "; cacheWriter=" + this.cacheWriterName + "]";
    }

    public void setCacheWriterName(String cacheWriterName) {
        this.cacheWriterName = cacheWriterName;
    }

    public String getCacheWriterName() {
        return this.cacheWriterName;
    }
}

