/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.memcached.commands;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.internal.memcached.KeyWrapper;
import com.gemstone.gemfire.internal.memcached.RequestReader;
import com.gemstone.gemfire.internal.memcached.commands.AbstractCommand;
import com.gemstone.gemfire.internal.memcached.commands.ClientError;
import com.gemstone.gemfire.memcached.GemFireMemcachedServer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public abstract class StorageCommand
extends AbstractCommand {
    private static ScheduledExecutorService expiryExecutor = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName("memcached-expiryExecutor");
            t.setDaemon(true);
            return t;
        }
    });
    private static ConcurrentMap<Object, ScheduledFuture> expiryFutures = new ConcurrentHashMap<Object, ScheduledFuture>();
    private static final long secsIn30Days = 2592000L;

    @Override
    public ByteBuffer processCommand(RequestReader reader, GemFireMemcachedServer.Protocol protocol, Cache cache) {
        ByteBuffer buffer = reader.getRequest();
        if (protocol == GemFireMemcachedServer.Protocol.ASCII) {
            return this.processAsciiCommand(buffer, cache);
        }
        return this.processBinaryComand(reader, cache);
    }

    private ByteBuffer processAsciiCommand(ByteBuffer buffer, Cache cache) {
        CharBuffer flb = this.getFirstLineBuffer();
        this.getAsciiDecoder().decode(buffer, flb, false);
        flb.flip();
        String firstLine = this.getFirstLine();
        String[] firstLineElements = firstLine.split(" ");
        String key = firstLineElements[1];
        int flags = Integer.parseInt(firstLineElements[2]);
        long expTime = Long.parseLong(firstLineElements[3]);
        int numBytes = Integer.parseInt(this.stripNewline(firstLineElements[4]));
        boolean noReply = false;
        if (firstLineElements.length > 5) {
            noReply = true;
        }
        byte[] value = new byte[numBytes];
        buffer.position(firstLine.length());
        try {
            for (int i = 0; i < numBytes; ++i) {
                value[i] = buffer.get();
            }
        }
        catch (BufferUnderflowException e) {
            throw new ClientError("error reading value");
        }
        if (this.getLogger().fineEnabled()) {
            this.getLogger().fine("key:" + key);
            this.getLogger().fine("value:" + Arrays.toString(value));
        }
        ByteBuffer retVal = this.processStorageCommand(key, value, flags, cache);
        if (expTime > 0L) {
            this.scheduleExpiration(key, expTime, cache);
        }
        return noReply ? null : retVal;
    }

    private ByteBuffer processBinaryComand(RequestReader request, Cache cache) {
        ByteBuffer buffer = request.getRequest();
        byte extrasLength = buffer.get(4);
        int flags = 0;
        int expTime = 0;
        KeyWrapper key = this.getKey(buffer, 24 + extrasLength);
        if (extrasLength > 0) {
            assert (extrasLength == 8);
            buffer.position(24);
            flags = buffer.getInt();
            expTime = buffer.getInt();
        }
        byte[] value = this.getValue(buffer);
        long cas = buffer.getLong(16);
        ByteBuffer retVal = this.processBinaryStorageCommand(key, value, cas, flags, cache, request);
        if (expTime > 0) {
            this.scheduleExpiration(key, expTime, cache);
        }
        if (this.getLogger().fineEnabled()) {
            this.getLogger().fine("key:" + key);
            this.getLogger().fine("value:" + Arrays.toString(value));
        }
        return retVal;
    }

    private void scheduleExpiration(Object key, long p_expTime, Cache cache) {
        long expTime = p_expTime;
        assert (expTime > 0L);
        if (p_expTime > 2592000L && (expTime = p_expTime - System.currentTimeMillis()) < 0L) {
            this.getLogger().info("Invalid expiration time passed, key:" + key + " will not expire");
            return;
        }
        ScheduledFuture<?> f = expiryExecutor.schedule(new ExpiryTask(cache, key), expTime, TimeUnit.SECONDS);
        expiryFutures.put(key, f);
    }

    public abstract ByteBuffer processStorageCommand(String var1, byte[] var2, int var3, Cache var4);

    public abstract ByteBuffer processBinaryStorageCommand(Object var1, byte[] var2, long var3, int var5, Cache var6, RequestReader var7);

    protected static ScheduledExecutorService getExpiryExecutor() {
        return expiryExecutor;
    }

    public static boolean rescheduleExpiration(Cache cache, Object key, int newExpTime) {
        ScheduledFuture f = (ScheduledFuture)expiryFutures.get(key);
        if (f != null && f.cancel(false)) {
            ScheduledFuture<?> f2 = expiryExecutor.schedule(new ExpiryTask(cache, key), (long)newExpTime, TimeUnit.SECONDS);
            expiryFutures.put(key, f2);
            return true;
        }
        return false;
    }

    public static class ExpiryTask
    implements Runnable {
        private final Cache cache;
        private final Object key;

        public ExpiryTask(Cache cache, Object key) {
            this.cache = cache;
            this.key = key;
        }

        @Override
        public void run() {
            AbstractCommand.getMemcachedRegion(this.cache).remove(this.key);
            expiryFutures.remove(this.key);
            if (this.cache.getLogger().fineEnabled()) {
                this.cache.getLogger().fine("expiration removed key:" + this.key);
            }
        }
    }
}

