/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.memcached.commands;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.memcached.Reply;
import com.gemstone.gemfire.internal.memcached.RequestReader;
import com.gemstone.gemfire.internal.memcached.ResponseStatus;
import com.gemstone.gemfire.internal.memcached.ValueWrapper;
import com.gemstone.gemfire.internal.memcached.commands.AbstractCommand;
import com.gemstone.gemfire.internal.memcached.commands.StorageCommand;
import com.gemstone.gemfire.memcached.GemFireMemcachedServer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.concurrent.TimeUnit;

public class FlushAllCommand
extends AbstractCommand {
    @Override
    public ByteBuffer processCommand(RequestReader request, GemFireMemcachedServer.Protocol protocol, Cache cache) {
        if (protocol == GemFireMemcachedServer.Protocol.ASCII) {
            return this.processAsciiCommand(request.getRequest(), cache);
        }
        return this.processBinaryCommand(request, cache);
    }

    private ByteBuffer processAsciiCommand(ByteBuffer buffer, Cache cache) {
        CharBuffer flb = this.getFirstLineBuffer();
        this.getAsciiDecoder().reset();
        this.getAsciiDecoder().decode(buffer, flb, false);
        flb.flip();
        String firstLine = this.getFirstLine();
        String[] firstLineElements = firstLine.split(" ");
        assert ("flush_all".equals(this.stripNewline(firstLineElements[0])));
        boolean noReply = false;
        int delay = 0;
        if (firstLineElements.length == 2) {
            if ("noreply".equals(this.stripNewline(firstLineElements[1]))) {
                noReply = true;
            } else {
                delay = Integer.parseInt(this.stripNewline(firstLineElements[1]));
            }
        } else if (firstLineElements.length == 3) {
            delay = Integer.parseInt(this.stripNewline(firstLineElements[1]));
            noReply = true;
        }
        final Region<Object, ValueWrapper> r = FlushAllCommand.getMemcachedRegion(cache);
        if (delay == 0) {
            r.destroyRegion();
        } else {
            StorageCommand.getExpiryExecutor().schedule(new Runnable(){

                @Override
                public void run() {
                    r.destroyRegion();
                }
            }, (long)delay, TimeUnit.SECONDS);
        }
        CharBuffer retVal = CharBuffer.wrap(Reply.OK.toString());
        return noReply ? null : asciiCharset.encode(retVal);
    }

    private ByteBuffer processBinaryCommand(RequestReader request, Cache cache) {
        ByteBuffer buffer = request.getRequest();
        final Region<Object, ValueWrapper> r = FlushAllCommand.getMemcachedRegion(cache);
        int delay = 0;
        byte extraLength = buffer.get(4);
        buffer.position(24);
        if (extraLength != 0) {
            delay = buffer.getInt();
        }
        if (this.getLogger().fineEnabled()) {
            cache.getLogger().fine("flush:delay:" + delay);
        }
        if (delay == 0) {
            try {
                r.destroyRegion();
            }
            catch (Exception e) {
                return this.handleBinaryException("", request, request.getResponse(), "flushall", e);
            }
        } else {
            StorageCommand.getExpiryExecutor().schedule(new Runnable(){

                @Override
                public void run() {
                    r.destroyRegion();
                }
            }, (long)delay, TimeUnit.SECONDS);
        }
        ByteBuffer response = request.getResponse();
        response.putShort(6, ResponseStatus.NO_ERROR.asShort());
        return this.isQuiet() ? null : response;
    }

    protected boolean isQuiet() {
        return false;
    }
}

