/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.memcached.commands;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.memcached.Reply;
import com.gemstone.gemfire.internal.memcached.RequestReader;
import com.gemstone.gemfire.internal.memcached.ResponseStatus;
import com.gemstone.gemfire.internal.memcached.ValueWrapper;
import com.gemstone.gemfire.internal.memcached.commands.StorageCommand;
import java.nio.ByteBuffer;

public class AddCommand
extends StorageCommand {
    @Override
    public ByteBuffer processStorageCommand(String key, byte[] value, int flags, Cache cache) {
        Region<Object, ValueWrapper> r = AddCommand.getMemcachedRegion(cache);
        ValueWrapper oldVal = r.putIfAbsent(key, ValueWrapper.getWrappedValue(value, flags));
        String reply = null;
        reply = oldVal == null ? Reply.STORED.toString() : Reply.NOT_STORED.toString();
        return asciiCharset.encode(reply);
    }

    @Override
    public ByteBuffer processBinaryStorageCommand(Object key, byte[] value, long cas, int flags, Cache cache, RequestReader request) {
        ByteBuffer response = request.getResponse();
        Region<Object, ValueWrapper> r = AddCommand.getMemcachedRegion(cache);
        ValueWrapper val = ValueWrapper.getWrappedValue(value, flags);
        try {
            ValueWrapper oldVal = r.putIfAbsent(key, val);
            if (oldVal == null) {
                if (this.getLogger().fineEnabled()) {
                    this.getLogger().fine("added key: " + key);
                }
                if (this.isQuiet()) {
                    return null;
                }
                response.putShort(6, ResponseStatus.NO_ERROR.asShort());
                response.putLong(16, val.getVersion());
            } else {
                if (this.getLogger().fineEnabled()) {
                    this.getLogger().fine("key: " + key + " not added as is already exists");
                }
                response.putShort(6, ResponseStatus.KEY_EXISTS.asShort());
            }
        }
        catch (Exception e) {
            response = this.handleBinaryException(key, request, response, "add", e);
        }
        return response;
    }

    protected boolean isQuiet() {
        return false;
    }
}

