/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.memcached;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.internal.memcached.Command;
import com.gemstone.gemfire.internal.memcached.RequestReader;
import com.gemstone.gemfire.internal.memcached.commands.ClientError;
import com.gemstone.gemfire.memcached.GemFireMemcachedServer;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;

public class ConnectionHandler
implements Runnable {
    private final Socket socket;
    private final Cache cache;
    private final GemFireMemcachedServer.Protocol protocol;
    private static LogWriter logger;

    public ConnectionHandler(Socket socket, Cache cache, GemFireMemcachedServer.Protocol protocol) {
        this.socket = socket;
        this.cache = cache;
        this.protocol = protocol;
        if (logger == null) {
            logger = this.cache.getLogger();
        }
    }

    @Override
    public void run() {
        RequestReader request = new RequestReader(this.socket, this.protocol);
        while (!Thread.currentThread().isInterrupted()) {
            try {
                ByteBuffer reply;
                Command command = request.readCommand();
                if (logger.fineEnabled()) {
                    logger.fine("processing command:" + (Object)((Object)command));
                }
                if ((reply = command.getCommandProcessor().processCommand(request, this.protocol, this.cache)) != null) {
                    request.sendReply(reply);
                }
                if (command != Command.QUIT && command != Command.QUITQ) continue;
                this.socket.close();
                break;
            }
            catch (ClientError e) {
                request.sendException(e);
            }
            catch (IllegalArgumentException e) {
                request.sendException(e);
            }
            catch (CacheClosedException cc) {
                Thread.currentThread().interrupt();
            }
            catch (IOException e) {
                Thread.currentThread().interrupt();
            }
        }
        logger.fine("Connection handler " + Thread.currentThread().getName() + " terminating");
    }

    protected static LogWriter getLogger() {
        return logger;
    }
}

