/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.memcached;

import com.gemstone.gemfire.internal.memcached.CommandProcessor;
import com.gemstone.gemfire.internal.memcached.commands.AddCommand;
import com.gemstone.gemfire.internal.memcached.commands.AddQCommand;
import com.gemstone.gemfire.internal.memcached.commands.AppendCommand;
import com.gemstone.gemfire.internal.memcached.commands.AppendQCommand;
import com.gemstone.gemfire.internal.memcached.commands.CASCommand;
import com.gemstone.gemfire.internal.memcached.commands.DecrementCommand;
import com.gemstone.gemfire.internal.memcached.commands.DecrementQCommand;
import com.gemstone.gemfire.internal.memcached.commands.DeleteCommand;
import com.gemstone.gemfire.internal.memcached.commands.DeleteQCommand;
import com.gemstone.gemfire.internal.memcached.commands.FlushAllCommand;
import com.gemstone.gemfire.internal.memcached.commands.FlushAllQCommand;
import com.gemstone.gemfire.internal.memcached.commands.GATCommand;
import com.gemstone.gemfire.internal.memcached.commands.GATQCommand;
import com.gemstone.gemfire.internal.memcached.commands.GetCommand;
import com.gemstone.gemfire.internal.memcached.commands.GetKCommand;
import com.gemstone.gemfire.internal.memcached.commands.GetKQCommand;
import com.gemstone.gemfire.internal.memcached.commands.GetQCommand;
import com.gemstone.gemfire.internal.memcached.commands.IncrementCommand;
import com.gemstone.gemfire.internal.memcached.commands.IncrementQCommand;
import com.gemstone.gemfire.internal.memcached.commands.NoOpCommand;
import com.gemstone.gemfire.internal.memcached.commands.NotSupportedCommand;
import com.gemstone.gemfire.internal.memcached.commands.PrependCommand;
import com.gemstone.gemfire.internal.memcached.commands.PrependQCommand;
import com.gemstone.gemfire.internal.memcached.commands.QuitCommand;
import com.gemstone.gemfire.internal.memcached.commands.QuitQCommand;
import com.gemstone.gemfire.internal.memcached.commands.ReplaceCommand;
import com.gemstone.gemfire.internal.memcached.commands.ReplaceQCommand;
import com.gemstone.gemfire.internal.memcached.commands.SetCommand;
import com.gemstone.gemfire.internal.memcached.commands.SetQCommand;
import com.gemstone.gemfire.internal.memcached.commands.StatsCommand;
import com.gemstone.gemfire.internal.memcached.commands.TouchCommand;
import com.gemstone.gemfire.internal.memcached.commands.VerbosityCommand;
import com.gemstone.gemfire.internal.memcached.commands.VersionCommand;
import java.nio.ByteBuffer;

public enum Command {
    SET{
        private CommandProcessor processor;

        @Override
        public CommandProcessor getCommandProcessor() {
            if (this.processor == null) {
                this.processor = new SetCommand();
            }
            return this.processor;
        }
    }
    ,
    SETQ{
        private CommandProcessor processor;

        @Override
        public CommandProcessor getCommandProcessor() {
            if (this.processor == null) {
                this.processor = new SetQCommand();
            }
            return this.processor;
        }
    }
    ,
    ADD{
        private CommandProcessor processor;

        @Override
        public CommandProcessor getCommandProcessor() {
            if (this.processor == null) {
                this.processor = new AddCommand();
            }
            return this.processor;
        }
    }
    ,
    ADDQ{
        private CommandProcessor processor;

        @Override
        public CommandProcessor getCommandProcessor() {
            if (this.processor == null) {
                this.processor = new AddQCommand();
            }
            return this.processor;
        }
    }
    ,
    REPLACE{
        private CommandProcessor processor;

        @Override
        public CommandProcessor getCommandProcessor() {
            if (this.processor == null) {
                this.processor = new ReplaceCommand();
            }
            return this.processor;
        }
    }
    ,
    REPLACEQ{
        private CommandProcessor processor;

        @Override
        public CommandProcessor getCommandProcessor() {
            if (this.processor == null) {
                this.processor = new ReplaceQCommand();
            }
            return this.processor;
        }
    }
    ,
    APPEND{
        private CommandProcessor processor;

        @Override
        public CommandProcessor getCommandProcessor() {
            if (this.processor == null) {
                this.processor = new AppendCommand();
            }
            return this.processor;
        }
    }
    ,
    APPENDQ{
        private CommandProcessor processor;

        @Override
        public CommandProcessor getCommandProcessor() {
            if (this.processor == null) {
                this.processor = new AppendQCommand();
            }
            return this.processor;
        }
    }
    ,
    PREPEND{
        private CommandProcessor processor;

        @Override
        public CommandProcessor getCommandProcessor() {
            if (this.processor == null) {
                this.processor = new PrependCommand();
            }
            return this.processor;
        }
    }
    ,
    PREPENDQ{
        private CommandProcessor processor;

        @Override
        public CommandProcessor getCommandProcessor() {
            if (this.processor == null) {
                this.processor = new PrependQCommand();
            }
            return this.processor;
        }
    }
    ,
    CAS{
        private CommandProcessor processor;

        @Override
        public CommandProcessor getCommandProcessor() {
            if (this.processor == null) {
                this.processor = new CASCommand();
            }
            return this.processor;
        }
    }
    ,
    GET{
        private CommandProcessor processor;

        @Override
        public CommandProcessor getCommandProcessor() {
            if (this.processor == null) {
                this.processor = new GetCommand();
            }
            return this.processor;
        }
    }
    ,
    GETS{
        private CommandProcessor processor;

        @Override
        public CommandProcessor getCommandProcessor() {
            if (this.processor == null) {
                this.processor = new GetCommand();
            }
            return this.processor;
        }
    }
    ,
    GETQ{
        private CommandProcessor processor;

        @Override
        public CommandProcessor getCommandProcessor() {
            if (this.processor == null) {
                this.processor = new GetQCommand();
            }
            return this.processor;
        }
    }
    ,
    GETK{
        private CommandProcessor processor;

        @Override
        public CommandProcessor getCommandProcessor() {
            if (this.processor == null) {
                this.processor = new GetKCommand();
            }
            return this.processor;
        }
    }
    ,
    GETKQ{
        private CommandProcessor processor;

        @Override
        public CommandProcessor getCommandProcessor() {
            if (this.processor == null) {
                this.processor = new GetKQCommand();
            }
            return this.processor;
        }
    }
    ,
    DELETE{
        private CommandProcessor processor;

        @Override
        public CommandProcessor getCommandProcessor() {
            if (this.processor == null) {
                this.processor = new DeleteCommand();
            }
            return this.processor;
        }
    }
    ,
    DELETEQ{
        private CommandProcessor processor;

        @Override
        public CommandProcessor getCommandProcessor() {
            if (this.processor == null) {
                this.processor = new DeleteQCommand();
            }
            return this.processor;
        }
    }
    ,
    INCR{
        private CommandProcessor processor;

        @Override
        public CommandProcessor getCommandProcessor() {
            if (this.processor == null) {
                this.processor = new IncrementCommand();
            }
            return this.processor;
        }
    }
    ,
    INCRQ{
        private CommandProcessor processor;

        @Override
        public CommandProcessor getCommandProcessor() {
            if (this.processor == null) {
                this.processor = new IncrementQCommand();
            }
            return this.processor;
        }
    }
    ,
    DECR{
        private CommandProcessor processor;

        @Override
        public CommandProcessor getCommandProcessor() {
            if (this.processor == null) {
                this.processor = new DecrementCommand();
            }
            return this.processor;
        }
    }
    ,
    DECRQ{
        private CommandProcessor processor;

        @Override
        public CommandProcessor getCommandProcessor() {
            if (this.processor == null) {
                this.processor = new DecrementQCommand();
            }
            return this.processor;
        }
    }
    ,
    STATS{
        private CommandProcessor processor;

        @Override
        public CommandProcessor getCommandProcessor() {
            if (this.processor == null) {
                this.processor = new StatsCommand();
            }
            return this.processor;
        }
    }
    ,
    FLUSH_ALL{
        private CommandProcessor processor;

        @Override
        public CommandProcessor getCommandProcessor() {
            if (this.processor == null) {
                this.processor = new FlushAllCommand();
            }
            return this.processor;
        }
    }
    ,
    FLUSH_ALLQ{
        private CommandProcessor processor;

        @Override
        public CommandProcessor getCommandProcessor() {
            if (this.processor == null) {
                this.processor = new FlushAllQCommand();
            }
            return this.processor;
        }
    }
    ,
    VERSION{
        private CommandProcessor processor;

        @Override
        public CommandProcessor getCommandProcessor() {
            if (this.processor == null) {
                this.processor = new VersionCommand();
            }
            return this.processor;
        }
    }
    ,
    VERBOSITY{
        private CommandProcessor processor;

        @Override
        public CommandProcessor getCommandProcessor() {
            if (this.processor == null) {
                this.processor = new VerbosityCommand();
            }
            return this.processor;
        }
    }
    ,
    QUIT{
        private CommandProcessor processor;

        @Override
        public CommandProcessor getCommandProcessor() {
            if (this.processor == null) {
                this.processor = new QuitCommand();
            }
            return this.processor;
        }
    }
    ,
    QUITQ{
        private CommandProcessor processor;

        @Override
        public CommandProcessor getCommandProcessor() {
            if (this.processor == null) {
                this.processor = new QuitQCommand();
            }
            return this.processor;
        }
    }
    ,
    NOOP{
        private CommandProcessor processor;

        @Override
        public CommandProcessor getCommandProcessor() {
            if (this.processor == null) {
                this.processor = new NoOpCommand();
            }
            return this.processor;
        }
    }
    ,
    TOUCH{
        private CommandProcessor processor;

        @Override
        public CommandProcessor getCommandProcessor() {
            if (this.processor == null) {
                this.processor = new TouchCommand();
            }
            return this.processor;
        }
    }
    ,
    GAT{
        private CommandProcessor processor;

        @Override
        public CommandProcessor getCommandProcessor() {
            if (this.processor == null) {
                this.processor = new GATCommand();
            }
            return this.processor;
        }
    }
    ,
    GATQ{
        private CommandProcessor processor;

        @Override
        public CommandProcessor getCommandProcessor() {
            if (this.processor == null) {
                this.processor = new GATQCommand();
            }
            return this.processor;
        }
    }
    ,
    NOT_SUPPORTED{
        private CommandProcessor processor;

        @Override
        public CommandProcessor getCommandProcessor() {
            if (this.processor == null) {
                this.processor = new NotSupportedCommand();
            }
            return this.processor;
        }
    };


    public abstract CommandProcessor getCommandProcessor();

    public static String buffertoString(ByteBuffer header) {
        StringBuilder str = new StringBuilder("\n0: ");
        for (int i = 0; i < header.limit(); ++i) {
            str.append(Command.byteToHex(header.get(i)) + " | ");
            if ((i + 1) % 4 != 0) continue;
            str.append("\n");
            str.append(i + 1 + ": ");
        }
        return str.toString();
    }

    public static Command getCommandFromOpCode(byte opCode) {
        switch (opCode) {
            case 0: {
                return GET;
            }
            case 1: {
                return SET;
            }
            case 2: {
                return ADD;
            }
            case 3: {
                return REPLACE;
            }
            case 4: {
                return DELETE;
            }
            case 5: {
                return INCR;
            }
            case 6: {
                return DECR;
            }
            case 7: {
                return QUIT;
            }
            case 8: {
                return FLUSH_ALL;
            }
            case 9: {
                return GETQ;
            }
            case 10: {
                return NOOP;
            }
            case 11: {
                return VERSION;
            }
            case 12: {
                return GETK;
            }
            case 13: {
                return GETKQ;
            }
            case 14: {
                return APPEND;
            }
            case 15: {
                return PREPEND;
            }
            case 16: {
                return STATS;
            }
            case 17: {
                return SETQ;
            }
            case 18: {
                return ADDQ;
            }
            case 19: {
                return REPLACEQ;
            }
            case 20: {
                return DELETEQ;
            }
            case 21: {
                return INCRQ;
            }
            case 22: {
                return DECRQ;
            }
            case 23: {
                return QUITQ;
            }
            case 24: {
                return FLUSH_ALLQ;
            }
            case 25: {
                return APPENDQ;
            }
            case 26: {
                return PREPENDQ;
            }
            case 27: {
                return VERBOSITY;
            }
            case 28: {
                return TOUCH;
            }
            case 29: {
                return GAT;
            }
            case 30: {
                return GATQ;
            }
        }
        return NOT_SUPPORTED;
    }

    public static String byteToHex(byte b) {
        char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] array = new char[]{hexDigit[b >> 4 & 0xF], hexDigit[b & 0xF]};
        return "0x" + new String(array);
    }
}

